/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.VertxException;
import io.vertx.pgclient.impl.PgDatabaseMetadata;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.pgclient.impl.auth.scram.ScramAuthentication;
import io.vertx.pgclient.impl.auth.scram.ScramSession;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.PasswordMessage;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.ScramClientFinalMessage;
import io.vertx.pgclient.impl.codec.StartupMessage;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class InitCommandCodec
extends PgCommandCodec<Connection, InitCommand> {
    private PgEncoder encoder;
    private String encoding;
    private ScramSession scramSession;

    InitCommandCodec(InitCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(PgEncoder encoder) {
        this.encoder = encoder;
        encoder.writeStartupMessage(new StartupMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).database(), ((InitCommand)this.cmd).properties()));
    }

    @Override
    public void handleAuthenticationMD5Password(byte[] salt) {
        this.encoder.writePasswordMessage(new PasswordMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password(), salt));
        this.encoder.flush();
    }

    @Override
    public void handleAuthenticationClearTextPassword() {
        this.encoder.writePasswordMessage(new PasswordMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password(), null));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSasl(ByteBuf in) {
        ScramAuthentication scramAuth = ScramAuthentication.INSTANCE;
        if (scramAuth == null) {
            throw new VertxException("Scram authentication not supported, missing com.ongres.scram:scram-client on the class/module path");
        }
        this.scramSession = scramAuth.session(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password().toCharArray());
        this.encoder.writeScramClientInitialMessage(this.scramSession.createInitialSaslMessage(in, this.encoder.channelHandlerContext()));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSaslContinue(ByteBuf in) {
        this.encoder.writeScramClientFinalMessage(new ScramClientFinalMessage(this.scramSession.receiveServerFirstMessage(in)));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSaslFinal(ByteBuf in) {
        this.scramSession.checkServerFinalMessage(in);
    }

    @Override
    public void handleAuthenticationOk() {
    }

    @Override
    public void handleParameterStatus(String key, String value) {
        if (key.equals("client_encoding")) {
            this.encoding = value;
        }
        if (key.equals("server_version")) {
            ((PgSocketConnection)((InitCommand)this.cmd).connection()).dbMetaData = new PgDatabaseMetadata(value);
        }
    }

    @Override
    public void handleBackendKeyData(int processId, int secretKey) {
        ((PgSocketConnection)((InitCommand)this.cmd).connection()).processId = processId;
        ((PgSocketConnection)((InitCommand)this.cmd).connection()).secretKey = secretKey;
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        this.decoder.fireCommandResponse(CommandResponse.failure((Throwable)((Object)errorResponse.toException())));
    }

    @Override
    public void handleReadyForQuery() {
        Charset cs = null;
        try {
            cs = Charset.forName(this.encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommandResponse fut = cs == null || !cs.equals(StandardCharsets.UTF_8) ? CommandResponse.failure((String)(this.encoding + " is not supported in the client only UTF8")) : CommandResponse.success((Object)((InitCommand)this.cmd).connection());
        this.decoder.fireCommandResponse(fut);
    }
}

