/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PgConnectionFactory
extends ConnectionFactoryBase {
    public PgConnectionFactory(VertxInternal context, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        super(context, options);
    }

    private void checkSslMode(PgConnectOptions options) {
        switch (options.getSslMode()) {
            case VERIFY_FULL: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode");
            }
        }
    }

    protected Future<Connection> doConnectInternal(SqlConnectOptions options, ContextInternal context) {
        PgConnectOptions pgOptions = PgConnectOptions.wrap(options);
        try {
            this.checkSslMode(pgOptions);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        SocketAddress server = options.getSocketAddress();
        return this.connect(server, context, true, pgOptions);
    }

    public void cancelRequest(PgConnectOptions options, int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        this.connect(options.getSocketAddress(), this.vertx.createEventLoopContext(), false, options).onComplete(ar -> {
            if (ar.succeeded()) {
                PgSocketConnection conn = (PgSocketConnection)((Object)((Object)ar.result()));
                conn.sendCancelRequestMessage(processId, secretKey, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private Future<Connection> connect(SocketAddress server, ContextInternal context, boolean sendStartupMessage, PgConnectOptions options) {
        Future connFuture;
        SslMode sslMode = options.isUsingDomainSocket() ? SslMode.DISABLE : options.getSslMode();
        switch (sslMode) {
            case DISABLE: {
                connFuture = this.connect(server, options, context, false, sendStartupMessage);
                break;
            }
            case ALLOW: {
                connFuture = this.connect(server, options, context, false, sendStartupMessage).recover(err -> this.connect(server, options, context, true, sendStartupMessage));
                break;
            }
            case PREFER: {
                connFuture = this.connect(server, options, context, true, sendStartupMessage).recover(err -> this.connect(server, options, context, false, sendStartupMessage));
                break;
            }
            case VERIFY_FULL: 
            case VERIFY_CA: 
            case REQUIRE: {
                connFuture = this.connect(server, options, context, true, sendStartupMessage);
                break;
            }
            default: {
                return context.failedFuture((Throwable)new IllegalArgumentException("Unsupported SSL mode"));
            }
        }
        return connFuture;
    }

    private Future<Connection> connect(SocketAddress server, PgConnectOptions connectOptions, ContextInternal context, boolean ssl, boolean sendStartupMessage) {
        Future<Connection> res = this.doConnect(server, connectOptions, context, ssl);
        if (sendStartupMessage) {
            return res.flatMap(conn -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                socket.init();
                String username = connectOptions.getUser();
                String password = connectOptions.getPassword();
                String database = connectOptions.getDatabase();
                Map properties = connectOptions.getProperties() != null ? Collections.unmodifiableMap(connectOptions.getProperties()) : null;
                return Future.future(p -> socket.sendStartupMessage(username, password, database, properties, (Promise<Connection>)p));
            });
        }
        return res;
    }

    private Future<Connection> doConnect(SocketAddress server, PgConnectOptions connectOptions, ContextInternal context, boolean ssl) {
        Future soFut;
        try {
            soFut = this.netClient((NetClientOptions)connectOptions).connect(server, (String)null);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        Future connFut = soFut.map(so -> this.newSocketConnection(context, (NetSocketInternal)so, connectOptions));
        if (ssl && !server.isDomainSocket()) {
            connFut = connFut.flatMap(conn -> Future.future(p -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                socket.upgradeToSSLConnection((Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                    if (ar2.succeeded()) {
                        p.complete(conn);
                    } else {
                        p.fail(ar2.cause());
                    }
                }));
            }));
        }
        return connFut;
    }

    public Future<SqlConnection> connect(Context context, SqlConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        if (options.isUsingDomainSocket() && !this.vertx.isNativeTransportEnabled()) {
            return contextInternal.failedFuture((Throwable)new IllegalArgumentException("The Vertx instance must use a native transport in order to connect to connect through domain sockets"));
        }
        PromiseInternal promise = contextInternal.promise();
        this.connect(PgConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            PgConnectionImpl pgConn = new PgConnectionImpl(this, contextInternal, (Connection)conn);
            conn.init((Connection.Holder)pgConn);
            return pgConn;
        }).onComplete((Handler)promise);
        return promise.future();
    }

    private PgSocketConnection newSocketConnection(ContextInternal context, NetSocketInternal socket, PgConnectOptions options) {
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheMaxSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        int pipeliningLimit = options.getPipeliningLimit();
        boolean useLayer7Proxy = options.getUseLayer7Proxy();
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        PgSocketConnection conn = new PgSocketConnection(socket, metrics, options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, useLayer7Proxy, context);
        return conn;
    }
}

