/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;

public class Money {
    private BigDecimal value;

    @Deprecated
    public Money(long integerPart, int decimalPart) {
        this(new BigDecimal(integerPart + "." + new DecimalFormat("00").format(decimalPart)));
    }

    public Money(Number value) {
        this.value = (value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value))).stripTrailingZeros();
        if (this.value.toBigInteger().abs().longValue() > 92233720368547758L) {
            throw new IllegalArgumentException("Value is too big: " + value);
        }
        if (this.value.scale() > 2) {
            throw new IllegalArgumentException("Value has more than two decimal digits: " + value);
        }
    }

    public Money() {
        this.value = BigDecimal.ZERO;
    }

    @Deprecated
    public long getIntegerPart() {
        return this.value.toBigInteger().longValue();
    }

    @Deprecated
    public int getDecimalPart() {
        return this.value.remainder(BigDecimal.ONE).movePointRight(this.value.scale()).abs().intValue();
    }

    @Deprecated
    public Money setIntegerPart(long part) {
        this.value = new Money(part, this.value.remainder(BigDecimal.ONE).abs().intValue()).bigDecimalValue();
        return this;
    }

    @Deprecated
    public Money setDecimalPart(int part) {
        this.value = new Money(this.value.longValue(), part).bigDecimalValue();
        return this;
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return Objects.equals(this.value, money.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Money(" + new DecimalFormat("#0.##").format(this.value) + ")";
    }
}

