/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class PgConnectionFactory
extends ConnectionFactoryBase {
    private SslMode sslMode;
    private int pipeliningLimit;

    public PgConnectionFactory(VertxInternal context, PgConnectOptions options) {
        super(context, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        PgConnectOptions options = (PgConnectOptions)connectOptions;
        this.pipeliningLimit = options.getPipeliningLimit();
        this.sslMode = options.isUsingDomainSocket() ? SslMode.DISABLE : options.getSslMode();
        switch (this.sslMode) {
            case VERIFY_FULL: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode");
            }
        }
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
        netClientOptions.setSsl(false);
    }

    protected Future<Connection> doConnectInternal(SocketAddress server, String username, String password, String database, EventLoopContext context) {
        return this.doConnect(server, context).flatMap(conn -> {
            PgSocketConnection socket = (PgSocketConnection)((Object)conn);
            socket.init();
            return Future.future(p -> socket.sendStartupMessage(username, password, database, this.properties, (Promise<Connection>)p)).map(conn);
        });
    }

    public void cancelRequest(SocketAddress server, int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        this.doConnect(server, this.vertx.createEventLoopContext()).onComplete(ar -> {
            if (ar.succeeded()) {
                PgSocketConnection conn = (PgSocketConnection)((Object)((Object)ar.result()));
                conn.sendCancelRequestMessage(processId, secretKey, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private Future<Connection> doConnect(SocketAddress server, EventLoopContext context) {
        Future connFuture;
        switch (this.sslMode) {
            case DISABLE: {
                connFuture = this.doConnect(server, context, false);
                break;
            }
            case ALLOW: {
                connFuture = this.doConnect(server, context, false).recover(err -> this.doConnect(server, context, true));
                break;
            }
            case PREFER: {
                connFuture = this.doConnect(server, context, true).recover(err -> this.doConnect(server, context, false));
                break;
            }
            case VERIFY_FULL: 
            case VERIFY_CA: 
            case REQUIRE: {
                connFuture = this.doConnect(server, context, true);
                break;
            }
            default: {
                return context.failedFuture((Throwable)new IllegalArgumentException("Unsupported SSL mode"));
            }
        }
        return connFuture;
    }

    private Future<Connection> doConnect(SocketAddress server, EventLoopContext context, boolean ssl) {
        Future soFut;
        try {
            soFut = this.netClient.connect(server, (String)null);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        Future connFut = soFut.map(so -> this.newSocketConnection(context, (NetSocketInternal)so));
        if (ssl && !server.isDomainSocket()) {
            connFut = connFut.flatMap(conn -> Future.future(p -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                socket.upgradeToSSLConnection((Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                    if (ar2.succeeded()) {
                        p.complete(conn);
                    } else {
                        p.fail(ar2.cause());
                    }
                }));
            }));
        }
        return connFut;
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal contextInternal = (ContextInternal)context;
        PromiseInternal promise = contextInternal.promise();
        this.connect(PgConnectionFactory.asEventLoopContext((ContextInternal)contextInternal)).map(conn -> {
            QueryTracer tracer = contextInternal.tracer() == null ? null : new QueryTracer(contextInternal.tracer(), this.options);
            PgConnectionImpl pgConn = new PgConnectionImpl(this, contextInternal, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)pgConn);
            return pgConn;
        }).onComplete((Handler)promise);
        return promise.future();
    }

    private PgSocketConnection newSocketConnection(EventLoopContext context, NetSocketInternal socket) {
        return new PgSocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, context);
    }
}

