/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.protocol;

import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;

public final class ColumnDefinition
implements ColumnDescriptor {
    private final String name;
    private final int characterSet;
    private final DataType type;
    private final int flags;

    public ColumnDefinition(String name, int characterSet, DataType type, int flags) {
        this.name = name;
        this.characterSet = characterSet;
        this.type = type;
        this.flags = flags;
    }

    public String name() {
        return this.name;
    }

    public int characterSet() {
        return this.characterSet;
    }

    public DataType type() {
        return this.type;
    }

    public int flags() {
        return this.flags;
    }

    public boolean isArray() {
        return false;
    }

    public String typeName() {
        return this.type.toString();
    }

    public JDBCType jdbcType() {
        return this.type.getJdbcType();
    }

    public String toString() {
        return "ColumnDefinition{, name='" + this.name + "', characterSet=" + this.characterSet + ", type=" + String.valueOf((Object)this.type) + ", flags=" + this.flags + "}";
    }

    public static final class ColumnDefinitionFlags {
        public static final int NOT_NULL_FLAG = 1;
        public static final int PRI_KEY_FLAG = 2;
        public static final int UNIQUE_KEY_FLAG = 4;
        public static final int MULTIPLE_KEY_FLAG = 8;
        public static final int BLOB_FLAG = 16;
        public static final int UNSIGNED_FLAG = 32;
        public static final int ZEROFILL_FLAG = 64;
        public static final int BINARY_FLAG = 128;
        public static final int ENUM_FLAG = 256;
        public static final int AUTO_INCREMENT_FLAG = 512;
        public static final int TIMESTAMP_FLAG = 1024;
        public static final int SET_FLAG = 2048;
        public static final int NO_DEFAULT_VALUE_FLAG = 4096;
        public static final int ON_UPDATE_NOW_FLAG = 8192;
        public static final int NUM_FLAG = 32768;
        public static final int PART_KEY_FLAG = 16384;
        public static final int GROUP_FLAG = 32768;
        public static final int UNIQUE_FLAG = 65536;
        public static final int BINCMP_FLAG = 131072;
        public static final int GET_FIXED_FIELDS_FLAG = 262144;
        public static final int FIELD_IN_PART_FUNC_FLAG = 524288;
        public static final int FIELD_IN_ADD_INDEX = 0x100000;
        public static final int FIELD_IS_RENAMED = 0x200000;
        public static final int FIELD_FLAGS_STORAGE_MEDIA = 22;
        public static final int FIELD_FLAGS_STORAGE_MEDIA_MASK = 0xC00000;
        public static final int FIELD_FLAGS_COLUMN_FORMAT = 24;
        public static final int FIELD_FLAGS_COLUMN_FORMAT_MASK = 0x3000000;
        public static final int FIELD_IS_DROPPED = 0x4000000;
        public static final int EXPLICIT_NULL_FLAG = 0x8000000;
        public static final int FIELD_IS_MARKED = 0x10000000;
    }

    public static final class ColumnType {
        public static final short MYSQL_TYPE_DECIMAL = 0;
        public static final short MYSQL_TYPE_TINY = 1;
        public static final short MYSQL_TYPE_SHORT = 2;
        public static final short MYSQL_TYPE_LONG = 3;
        public static final short MYSQL_TYPE_FLOAT = 4;
        public static final short MYSQL_TYPE_DOUBLE = 5;
        public static final short MYSQL_TYPE_NULL = 6;
        public static final short MYSQL_TYPE_TIMESTAMP = 7;
        public static final short MYSQL_TYPE_LONGLONG = 8;
        public static final short MYSQL_TYPE_INT24 = 9;
        public static final short MYSQL_TYPE_DATE = 10;
        public static final short MYSQL_TYPE_TIME = 11;
        public static final short MYSQL_TYPE_DATETIME = 12;
        public static final short MYSQL_TYPE_YEAR = 13;
        public static final short MYSQL_TYPE_VARCHAR = 15;
        public static final short MYSQL_TYPE_BIT = 16;
        public static final short MYSQL_TYPE_JSON = 245;
        public static final short MYSQL_TYPE_NEWDECIMAL = 246;
        public static final short MYSQL_TYPE_ENUM = 247;
        public static final short MYSQL_TYPE_SET = 248;
        public static final short MYSQL_TYPE_TINY_BLOB = 249;
        public static final short MYSQL_TYPE_MEDIUM_BLOB = 250;
        public static final short MYSQL_TYPE_LONG_BLOB = 251;
        public static final short MYSQL_TYPE_BLOB = 252;
        public static final short MYSQL_TYPE_VAR_STRING = 253;
        public static final short MYSQL_TYPE_STRING = 254;
        public static final short MYSQL_TYPE_GEOMETRY = 255;
        private static final int MYSQL_TYPE_NEWDATE = 14;
        private static final int MYSQL_TYPE_TIMESTAMP2 = 17;
        private static final int MYSQL_TYPE_DATETIME2 = 18;
        private static final int MYSQL_TYPE_TIME2 = 19;
    }
}

