/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLDatabaseMetadata;
import io.vertx.mysqlclient.impl.codec.ClearCachedStatementsEvent;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;
import io.vertx.mysqlclient.impl.codec.MySQLPacketDecoder;
import io.vertx.mysqlclient.impl.command.InitialHandshakeCommand;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.QueryCommandBase;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import io.vertx.sqlclient.internal.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;

public class MySQLSocketConnection
extends SocketConnectionBase {
    private final MySQLConnectOptions connectOptions;
    public MySQLDatabaseMetadata metaData;
    private MySQLCodec codec;

    public MySQLSocketConnection(NetSocketInternal socket, ClientMetrics clientMetrics, MySQLConnectOptions connectOptions, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, ContextInternal context) {
        super(socket, clientMetrics, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        this.connectOptions = connectOptions;
    }

    void sendStartupMessage(String username, String password, String database, MySQLCollation collation, Buffer serverRsaPublicKey, Map<String, String> properties, SslMode sslMode, ClientSSLOptions sslOptions, int initialCapabilitiesFlags, Charset charsetEncoding, MySQLAuthenticationPlugin authenticationPlugin, Promise<Connection> completionHandler) {
        InitialHandshakeCommand cmd = new InitialHandshakeCommand(this, username, password, database, collation, serverRsaPublicKey, properties, sslMode, sslOptions, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin);
        this.schedule(this.context, cmd).onComplete(completionHandler);
    }

    protected SqlConnectOptions connectOptions() {
        return this.connectOptions;
    }

    public void init() {
        this.codec = new MySQLCodec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        pipeline.addBefore("codec", "packetDecoder", (ChannelHandler)new MySQLPacketDecoder());
        super.init();
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Completable<R> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(tx.kind.sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, (res, err) -> handler.complete(tx.result, err));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    protected void handleMessage(Object msg) {
        if (msg == ClearCachedStatementsEvent.INSTANCE) {
            this.clearCachedStatements();
        } else {
            super.handleMessage(msg);
        }
    }

    private void clearCachedStatements() {
        if (this.psCache != null) {
            this.psCache.clear();
        }
    }

    public Future<Void> upgradeToSsl(ClientSSLOptions sslOptions) {
        return this.socket.upgradeToSsl((SSLOptions)sslOptions);
    }

    public String system() {
        return this.metaData.system();
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.metaData;
    }
}

