/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;

public class MySQLConnectionFactory
extends ConnectionFactoryBase<MySQLConnectOptions> {
    public MySQLConnectionFactory(VertxInternal vertx) {
        super(vertx);
    }

    protected Future<Connection> doConnectInternal(MySQLConnectOptions options, ContextInternal context) {
        SslMode sslMode = options.isUsingDomainSocket() ? SslMode.DISABLED : options.getSslMode();
        ClientSSLOptions sslOptions = options.getSslOptions();
        switch (sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = sslOptions.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm != null && !hostnameVerificationAlgorithm.isEmpty()) break;
                return context.failedFuture((Throwable)new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode."));
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = sslOptions.getTrustOptions();
                if (trustOptions != null) break;
                return context.failedFuture((Throwable)new IllegalArgumentException("Trust options must be specified under " + sslMode.name() + " ssl-mode."));
            }
            case DISABLED: {
                sslOptions = null;
            }
        }
        if (sslOptions != null && sslOptions.getHostnameVerificationAlgorithm() == null) {
            sslOptions.setHostnameVerificationAlgorithm("");
        }
        int capabilitiesFlag = this.capabilitiesFlags(options);
        if (sslMode == SslMode.PREFERRED) {
            return this.doConnect(options, sslMode, sslOptions, capabilitiesFlag, context).recover(err -> this.doConnect(options, SslMode.DISABLED, null, capabilitiesFlag, context));
        }
        return this.doConnect(options, sslMode, sslOptions, capabilitiesFlag, context);
    }

    private int capabilitiesFlags(MySQLConnectOptions options) {
        int capabilitiesFlags = 3121797;
        if (options.getDatabase() != null && !options.getDatabase().isEmpty()) {
            capabilitiesFlags |= 8;
        }
        if (options.getProperties() != null && !options.getProperties().isEmpty()) {
            capabilitiesFlags |= 0x100000;
        }
        if (!options.isUseAffectedRows()) {
            capabilitiesFlags |= 2;
        }
        return capabilitiesFlags;
    }

    private Future<Connection> doConnect(MySQLConnectOptions options, SslMode sslMode, ClientSSLOptions sslOptions, int initialCapabilitiesFlags, ContextInternal context) {
        Charset charsetEncoding;
        MySQLCollation collation;
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        SocketAddress server = options.getSocketAddress();
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheMaxSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        Map properties = options.getProperties();
        if (options.getCollation() != null) {
            collation = MySQLCollation.valueOfName(options.getCollation());
            charsetEncoding = Charset.forName(collation.mappedJavaCharsetName());
        } else {
            String charset = options.getCharset();
            collation = charset == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset));
            String characterEncoding = options.getCharacterEncoding();
            charsetEncoding = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(options.getCharacterEncoding());
        }
        Object serverRsaPublicKey = options.getServerRsaPublicKeyValue() != null ? options.getServerRsaPublicKeyValue() : (options.getServerRsaPublicKeyPath() != null ? this.vertx.fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath()) : null);
        int pipeliningLimit = options.getPipeliningLimit();
        MySQLAuthenticationPlugin authenticationPlugin = options.getAuthenticationPlugin();
        ConnectOptions connectOptions = new ConnectOptions().setRemoteAddress(server);
        Future fut = this.client.connect(connectOptions);
        return fut.flatMap(arg_0 -> this.lambda$doConnect$2(options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, context, username, password, database, collation, (Buffer)serverRsaPublicKey, properties, sslMode, sslOptions, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin, arg_0));
    }

    public Future<SqlConnection> connect(Context context, MySQLConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        PromiseInternal promise = contextInternal.promise();
        this.connect(MySQLConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            MySQLConnectionImpl mySQLConnection = new MySQLConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)mySQLConnection);
            return mySQLConnection;
        }).onComplete((Completable)promise);
        return promise.future();
    }

    private /* synthetic */ Future lambda$doConnect$2(MySQLConnectOptions options, boolean cachePreparedStatements, int preparedStatementCacheMaxSize, Predicate preparedStatementCacheSqlFilter, int pipeliningLimit, ContextInternal context, String username, String password, String database, MySQLCollation collation, Buffer serverRsaPublicKey, Map properties, SslMode sslMode, ClientSSLOptions sslOptions, int initialCapabilitiesFlags, Charset charsetEncoding, MySQLAuthenticationPlugin authenticationPlugin, NetSocket so) {
        VertxMetrics vertxMetrics = this.vertx.metrics();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        MySQLSocketConnection conn = new MySQLSocketConnection((NetSocketInternal)so, metrics, options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        conn.init();
        return Future.future(promise -> conn.sendStartupMessage(username, password, database, collation, serverRsaPublicKey, properties, sslMode, sslOptions, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin, (Promise<Connection>)promise));
    }
}

