/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputFormat;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.Format;
import io.vertx.json.schema.impl.SchemaRepositoryImpl;
import io.vertx.json.schema.impl.SchemaValidatorInternal;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaValidatorImpl
implements SchemaValidatorInternal {
    private final Map<String, JsonSchema> lookup;
    private final JsonSchema schema;
    private final Draft draft;
    private final OutputFormat outputFormat;

    public SchemaValidatorImpl(JsonSchema schema, JsonSchemaOptions options, Map<String, JsonSchema> lookup) {
        Objects.requireNonNull(schema, "'schema' cannot be null");
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getOutputFormat(), "'options.outputFormat' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        Objects.requireNonNull(options, "'lookup' cannot be null");
        this.schema = schema;
        this.draft = options.getDraft() == null ? Draft.fromIdentifier((String)schema.get("$schema")) : options.getDraft();
        Objects.requireNonNull(schema, "'draft' cannot be null either #schema.$draft or options.draft");
        this.outputFormat = options.getOutputFormat();
        URL baseUri = new URL(options.getBaseUri());
        this.lookup = new HashMap<String, JsonSchema>(lookup);
        SchemaRepositoryImpl.dereference(this.lookup, schema, baseUri, "", true);
    }

    public SchemaValidatorImpl(String ref, JsonSchemaOptions options, Map<String, JsonSchema> lookup) {
        Objects.requireNonNull(ref, "'ref' cannot be null");
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getOutputFormat(), "'options.outputFormat' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        Objects.requireNonNull(options, "'lookup' cannot be null");
        this.schema = lookup.get(ref);
        this.draft = options.getDraft() == null ? Draft.fromIdentifier((String)this.schema.get("$schema")) : options.getDraft();
        Objects.requireNonNull(this.schema, "'draft' cannot be null either #schema.$draft or options.draft");
        this.outputFormat = options.getOutputFormat();
        this.lookup = lookup;
    }

    @Override
    public JsonSchema schema() {
        return this.schema;
    }

    @Override
    public OutputUnit validate(Object instance) throws SchemaException {
        return this.validate(instance, this.schema, null, "#", "#", new HashSet<Object>());
    }

    /*
     * Enabled aggressive block sorting
     */
    private OutputUnit validate(Object _instance, JsonSchema schema, JsonSchema _recursiveAnchor, String instanceLocation, String schemaLocation, Set<Object> evaluated) throws SchemaException {
        ArrayList<OutputUnit> arrayList;
        ArrayList<OutputUnit> annotations;
        List<OutputUnit> errors;
        block140: {
            boolean stop;
            int length;
            String keywordLocation;
            int i;
            JsonSchema recursiveAnchor;
            Object instance;
            block145: {
                OutputUnit result;
                block139: {
                    block146: {
                        Object result2;
                        String subInstancePointer;
                        String key5;
                        Object propsOrSchema;
                        block149: {
                            boolean stop2;
                            HashSet<String> thisEvaluated;
                            block148: {
                                block147: {
                                    String instanceType;
                                    block143: {
                                        OutputUnit elseResult;
                                        String keywordLocation2;
                                        block144: {
                                            OutputUnit thenResult;
                                            OutputUnit result3;
                                            Iterator subEvaluated;
                                            block142: {
                                                block141: {
                                                    if (schema instanceof BooleanSchema) {
                                                        if (schema != BooleanSchema.TRUE) return new OutputUnit(false).setErrors(Collections.singletonList(new OutputUnit(instanceLocation, "false", instanceLocation, "False boolean schema")));
                                                        return new OutputUnit(true).setErrors(Collections.emptyList());
                                                    }
                                                    instance = Utils.JSON.jsonify(_instance);
                                                    instanceType = Utils.JSON.typeOf(instance);
                                                    errors = new ArrayList<OutputUnit>();
                                                    annotations = new ArrayList<OutputUnit>();
                                                    if (schema.get("$recursiveAnchor", false).booleanValue() && _recursiveAnchor == null) {
                                                        _recursiveAnchor = schema;
                                                    }
                                                    recursiveAnchor = _recursiveAnchor;
                                                    if ("#".equals(schema.get("$recursiveRef"))) {
                                                        String keywordLocation3;
                                                        JsonSchema refSchema;
                                                        assert (schema.containsKey("__absolute_recursive_ref__"));
                                                        OutputUnit result4 = this.validate(instance, recursiveAnchor == null ? schema : recursiveAnchor, refSchema = recursiveAnchor == null ? this.lookup.get(schema.get("__absolute_recursive_ref__")) : recursiveAnchor, instanceLocation, keywordLocation3 = schemaLocation + "/$recursiveRef", evaluated);
                                                        if (!result4.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, "$recursiveRef", keywordLocation3, "A sub-schema had errors"));
                                                            errors.addAll(result4.getErrors());
                                                        }
                                                    }
                                                    if (schema.containsKey("$ref")) {
                                                        String keywordLocation4;
                                                        String uri = (String)schema.get("__absolute_ref__", schema.get("$ref"));
                                                        if (!this.lookup.containsKey(uri)) {
                                                            String message = "Unresolved $ref " + (String)schema.get("$ref");
                                                            if (schema.containsKey("__absolute_ref__") && !schema.get("__absolute_ref__").equals(schema.get("$ref"))) {
                                                                message = message + ": Absolute URI " + schema.get("__absolute_ref__");
                                                            }
                                                            message = message + "\nKnown schemas:\n- " + String.join((CharSequence)"\n- ", this.lookup.keySet());
                                                            throw new SchemaException(schema, message);
                                                        }
                                                        JsonSchema refSchema = this.lookup.get(uri);
                                                        OutputUnit result5 = this.validate(instance, refSchema, recursiveAnchor, instanceLocation, keywordLocation4 = schemaLocation + "/" + (String)schema.get("$ref"), evaluated);
                                                        if (!result5.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, "$ref", keywordLocation4, "A subschema had errors"));
                                                            errors.addAll(result5.getErrors());
                                                        }
                                                        if (this.draft == Draft.DRAFT4) return new OutputUnit(errors.isEmpty()).setErrors(errors);
                                                        if (this.draft == Draft.DRAFT7) {
                                                            return new OutputUnit(errors.isEmpty()).setErrors(errors);
                                                        }
                                                    }
                                                    if (schema.get("type") instanceof JsonArray) break block141;
                                                    if ("integer".equals(schema.get("type"))) {
                                                        if (!"number".equals(instanceType) || !Utils.Numbers.isInteger(instance)) {
                                                            errors.add(new OutputUnit(instanceLocation, "type", schemaLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type")));
                                                        }
                                                        break block142;
                                                    } else if (schema.containsKey("type") && !instanceType.equals(schema.get("type"))) {
                                                        errors.add(new OutputUnit(instanceLocation, "type", schemaLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type")));
                                                    }
                                                    break block142;
                                                }
                                                JsonArray type = (JsonArray)schema.get("type");
                                                int length2 = type.size();
                                                boolean valid = false;
                                                for (int i2 = 0; i2 < length2; ++i2) {
                                                    if (!instanceType.equals(type.getString(i2)) && (!"integer".equals(type.getString(i2)) || !"number".equals(instanceType) || !Utils.Numbers.isInteger(instance))) continue;
                                                    valid = true;
                                                    break;
                                                }
                                                if (!valid) {
                                                    errors.add(new OutputUnit(instanceLocation, "type", schemaLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + String.join((CharSequence)", ", type.getList())));
                                                }
                                            }
                                            if (schema.containsKey("const")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (!Utils.JSON.deepCompare(instance, schema.get("const"))) {
                                                        errors.add(new OutputUnit(instanceLocation, "const", schemaLocation + "/const", "Instance does not match " + Json.encode(schema.get("const"))));
                                                    }
                                                } else if (!Utils.Objects.equals(schema.get("const"), instance)) {
                                                    errors.add(new OutputUnit(instanceLocation, "const", schemaLocation + "/const", "Instance does not match " + Json.encode(schema.get("const"))));
                                                }
                                            }
                                            if (schema.containsKey("enum")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.JSON.deepCompare(instance, value))) {
                                                        errors.add(new OutputUnit(instanceLocation, "enum", schemaLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum"))));
                                                    }
                                                } else if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.Objects.equals(instance, value))) {
                                                    errors.add(new OutputUnit(instanceLocation, "enum", schemaLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum"))));
                                                }
                                            }
                                            if (schema.containsKey("not")) {
                                                String keywordLocation5 = schemaLocation + "/not";
                                                OutputUnit result6 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "not"), recursiveAnchor, instanceLocation, keywordLocation5, new HashSet<Object>());
                                                if (result6.getValid().booleanValue()) {
                                                    errors.add(new OutputUnit(instanceLocation, "not", keywordLocation5, "Instance matched \"not\" schema"));
                                                }
                                            }
                                            HashSet subEvaluateds = new HashSet();
                                            if (schema.containsKey("anyOf")) {
                                                String keywordLocation6 = schemaLocation + "/anyOf";
                                                int errorsLength = errors.size();
                                                boolean anyValid = false;
                                                for (i = 0; i < ((JsonArray)schema.get("anyOf")).size(); ++i) {
                                                    subEvaluated = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("anyOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, keywordLocation6 + "/" + i, (Set<Object>)((Object)subEvaluated));
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = anyValid = anyValid || result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(subEvaluated);
                                                }
                                                if (anyValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, "anyOf", keywordLocation6, "Instance does not match any subschemas"));
                                                }
                                            }
                                            if (schema.containsKey("allOf")) {
                                                String keywordLocation7 = schemaLocation + "/allOf";
                                                int errorsLength = errors.size();
                                                boolean allValid = true;
                                                for (i = 0; i < ((JsonArray)schema.get("allOf")).size(); ++i) {
                                                    subEvaluated = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("allOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, keywordLocation7 + "/" + i, (Set<Object>)((Object)subEvaluated));
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = allValid = allValid && result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(subEvaluated);
                                                }
                                                if (allValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, "allOf", keywordLocation7, "Instance does not match every subschema"));
                                                }
                                            }
                                            if (schema.containsKey("oneOf")) {
                                                String keywordLocation8 = schemaLocation + "/oneOf";
                                                int errorsLength = errors.size();
                                                int matches = 0;
                                                for (i = 0; i < ((JsonArray)schema.get("oneOf")).size(); ++i) {
                                                    subEvaluated = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("oneOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, keywordLocation8 + "/" + i, (Set<Object>)((Object)subEvaluated));
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    if (result3.getValid().booleanValue()) {
                                                        subEvaluateds.addAll(subEvaluated);
                                                    }
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    ++matches;
                                                }
                                                if (matches == 1) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, "oneOf", keywordLocation8, "Instance does not match exactly one subschema (" + matches + " matches)"));
                                                }
                                            }
                                            if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                evaluated.addAll(subEvaluateds);
                                            }
                                            if (!schema.containsKey("if")) break block143;
                                            keywordLocation2 = schemaLocation + "/if";
                                            OutputUnit conditionResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "if"), recursiveAnchor, instanceLocation, keywordLocation2, evaluated);
                                            if (!conditionResult.getValid().booleanValue()) break block144;
                                            if (schema.containsKey("then") && !(thenResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "then"), recursiveAnchor, instanceLocation, schemaLocation + "/then", evaluated)).getValid().booleanValue()) {
                                                errors.add(new OutputUnit(instanceLocation, "if", keywordLocation2, "Instance does not match \"then\" schema"));
                                                if (thenResult.getErrors() != null) {
                                                    errors.addAll(thenResult.getErrors());
                                                }
                                            }
                                            break block143;
                                        }
                                        if (schema.containsKey("else") && !(elseResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "else"), recursiveAnchor, instanceLocation, schemaLocation + "/else", evaluated)).getValid().booleanValue()) {
                                            errors.add(new OutputUnit(instanceLocation, "if", keywordLocation2, "Instance does not match \"else\" schema"));
                                            if (elseResult.getErrors() != null) {
                                                errors.addAll(elseResult.getErrors());
                                            }
                                        }
                                    }
                                    switch (instanceType) {
                                        case "object": {
                                            Object result7;
                                            if (schema.containsKey("required")) {
                                                for (Object key2 : (JsonArray)schema.get("required")) {
                                                    if (((JsonObject)instance).containsKey((String)key2)) continue;
                                                    errors.add(new OutputUnit(instanceLocation, "required", schemaLocation + "/required", "Instance does not have required property \"" + key2 + "\""));
                                                }
                                            }
                                            Set keys = ((JsonObject)instance).fieldNames();
                                            if (schema.containsKey("minProperties") && keys.size() < (Integer)schema.get("minProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, "minProperties", schemaLocation + "/minProperties", "Instance does not have at least " + schema.get("minProperties") + " properties"));
                                            }
                                            if (schema.containsKey("maxProperties") && keys.size() > (Integer)schema.get("maxProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, "maxProperties", schemaLocation + "/maxProperties", "Instance does not have at least " + schema.get("maxProperties") + " properties"));
                                            }
                                            if (schema.containsKey("propertyNames")) {
                                                String keywordLocation9 = schemaLocation + "/propertyNames";
                                                for (String key3 : ((JsonObject)instance).fieldNames()) {
                                                    String subInstancePointer2 = instanceLocation + "/" + Utils.Pointers.encode(key3);
                                                    result7 = this.validate(key3, Utils.Schemas.wrap((JsonObject)schema, "propertyNames"), recursiveAnchor, subInstancePointer2, keywordLocation9, new HashSet<Object>());
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, "propertyNames", keywordLocation9, "Property name \"" + key3 + "\" does not match schema"));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependentRequired")) {
                                                String keywordLocation10 = schemaLocation + "/dependantRequired";
                                                for (String key3 : ((JsonObject)schema.get("dependentRequired")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key3)) continue;
                                                    JsonArray required = ((JsonObject)schema.get("dependentRequired")).getJsonArray(key3);
                                                    for (Object dependantKey : required) {
                                                        if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                        errors.add(new OutputUnit(instanceLocation, "dependentRequired", keywordLocation10, "Instance has \"" + key3 + "\" but does not have \"" + dependantKey + "\""));
                                                    }
                                                }
                                            }
                                            if (schema.containsKey("dependentSchemas")) {
                                                for (Object key4 : ((JsonObject)schema.get("dependentSchemas")).fieldNames()) {
                                                    OutputUnit result8;
                                                    keywordLocation = schemaLocation + "/dependentSchemas";
                                                    if (!((JsonObject)instance).containsKey((String)key4) || (result8 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependentSchemas"), (String)key4), recursiveAnchor, instanceLocation, keywordLocation + "/" + Utils.Pointers.encode((String)key4), evaluated)).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, "dependentSchemas", keywordLocation, "Instance has \"" + (String)key4 + "\" but does not match dependant schema"));
                                                    if (result8.getErrors() == null) continue;
                                                    errors.addAll(result8.getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependencies")) {
                                                String keywordLocation11 = schemaLocation + "/dependencies";
                                                for (String key3 : ((JsonObject)schema.get("dependencies")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key3)) continue;
                                                    propsOrSchema = ((JsonObject)schema.get("dependencies")).getValue(key3);
                                                    if (propsOrSchema instanceof JsonArray) {
                                                        for (Object dependantKey : (JsonArray)propsOrSchema) {
                                                            if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                            errors.add(new OutputUnit(instanceLocation, "dependencies", keywordLocation11, "Instance has \"" + key3 + "\" but does not have \"" + dependantKey + "\""));
                                                        }
                                                        continue;
                                                    }
                                                    result7 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependencies"), key3), recursiveAnchor, instanceLocation, keywordLocation11 + "/" + Utils.Pointers.encode(key3), new HashSet<Object>());
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, "dependencies", keywordLocation11, "Instance has \"" + key3 + "\" but does not match dependant schema"));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            thisEvaluated = new HashSet<String>();
                                            stop2 = false;
                                            if (schema.containsKey("properties")) {
                                                keywordLocation = schemaLocation + "/properties";
                                                for (String key5 : ((JsonObject)schema.get("properties")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key5)) continue;
                                                    subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key5);
                                                    result2 = this.validate(((JsonObject)instance).getValue(key5), Utils.Schemas.wrap((JsonObject)schema.get("properties"), key5), recursiveAnchor, subInstancePointer, keywordLocation + "/" + Utils.Pointers.encode(key5), new HashSet<Object>());
                                                    if (((OutputUnit)result2).getValid().booleanValue()) {
                                                        evaluated.add(key5);
                                                        thisEvaluated.add(key5);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, "properties", keywordLocation, "Property \"" + key5 + "\" does not match schema"));
                                                    if (((OutputUnit)result2).getErrors() != null) {
                                                        errors.addAll(((OutputUnit)result2).getErrors());
                                                    }
                                                    if (!stop2) continue;
                                                }
                                            }
                                            if (stop2 || !schema.containsKey("patternProperties")) break;
                                            keywordLocation = schemaLocation + "/patternProperties";
                                            for (String pattern : ((JsonObject)schema.get("patternProperties")).fieldNames()) {
                                                Pattern regex = Pattern.compile(pattern);
                                                for (String key6 : ((JsonObject)instance).fieldNames()) {
                                                    if (!regex.matcher(key6).find()) continue;
                                                    String subInstancePointer3 = instanceLocation + "/" + Utils.Pointers.encode(key6);
                                                    OutputUnit result9 = this.validate(((JsonObject)instance).getValue(key6), Utils.Schemas.wrap((JsonObject)schema.get("patternProperties"), pattern), recursiveAnchor, subInstancePointer3, keywordLocation + "/" + Utils.Pointers.encode(pattern), new HashSet<Object>());
                                                    if (result9.getValid().booleanValue()) {
                                                        evaluated.add(key6);
                                                        thisEvaluated.add(key6);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, "patternProperties", keywordLocation, "Property \"" + key6 + "\" matches pattern \"" + pattern + "\" but does not match associated schema"));
                                                    if (result9.getErrors() == null) continue;
                                                    errors.addAll(result9.getErrors());
                                                }
                                            }
                                            break;
                                        }
                                        case "array": {
                                            int length2;
                                            if (schema.containsKey("maxItems") && ((JsonArray)instance).size() > (Integer)schema.get("maxItems")) {
                                                errors.add(new OutputUnit(instanceLocation, "maxItems", schemaLocation + "/maxItems", "Array has too many items ( + " + ((JsonArray)instance).size() + " > " + schema.get("maxItems") + ")"));
                                            }
                                            if (schema.containsKey("minItems") && ((JsonArray)instance).size() < (Integer)schema.get("minItems")) {
                                                errors.add(new OutputUnit(instanceLocation, "minItems", schemaLocation + "/minItems", "Array has too few items ( + " + ((JsonArray)instance).size() + " < " + schema.get("minItems") + ")"));
                                            }
                                            length = ((JsonArray)instance).size();
                                            stop = false;
                                            if (schema.containsKey("prefixItems")) {
                                                keywordLocation = schemaLocation + "/prefixItems";
                                                length2 = Math.min(((JsonArray)schema.get("prefixItems")).size(), length);
                                                for (i = 0; i < length2; ++i) {
                                                    result = this.validate(((JsonArray)instance).getValue(i), Utils.Schemas.wrap((JsonArray)schema.get("prefixItems"), i), recursiveAnchor, instanceLocation + "/" + i, keywordLocation + "/" + i, new HashSet<Object>());
                                                    evaluated.add(i);
                                                    if (result.getValid().booleanValue()) continue;
                                                    stop = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, "prefixItems", keywordLocation, "Items did not match schema"));
                                                    if (result.getErrors() != null) {
                                                        errors.addAll(result.getErrors());
                                                    }
                                                    if (stop) break;
                                                }
                                            }
                                            if (!schema.containsKey("items")) break block145;
                                            keywordLocation = schemaLocation + "/items";
                                            if (!(schema.get("items") instanceof JsonArray)) break block146;
                                            length2 = Math.min(((JsonArray)schema.get("items")).size(), length);
                                            while (i < length2) {
                                                result = this.validate(((JsonArray)instance).getValue(i), Utils.Schemas.wrap((JsonArray)schema.get("items"), i), recursiveAnchor, instanceLocation + "/" + i, keywordLocation + "/" + i, new HashSet<Object>());
                                                evaluated.add(i);
                                                if (!result.getValid().booleanValue()) {
                                                    stop = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, "items", keywordLocation, "Items did not match schema"));
                                                    if (result.getErrors() != null) {
                                                        errors.addAll(result.getErrors());
                                                    }
                                                    if (stop) break block139;
                                                }
                                                ++i;
                                            }
                                            break block139;
                                        }
                                        case "number": {
                                            double remainder;
                                            if (this.draft == Draft.DRAFT4) {
                                                if (schema.containsKey("minimum") && (schema.get("exclusiveMinimum", false).booleanValue() && Utils.Numbers.lte((Number)instance, schema.get("minimum")) || Utils.Numbers.lt((Number)instance, schema.get("minimum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, "minimum", schemaLocation + "/minimum", instance + " is less than " + (schema.get("exclusiveMinimum", false) != false ? "or equal to " : "") + schema.get("minimum")));
                                                }
                                                if (schema.containsKey("maximum") && (schema.get("exclusiveMaximum", false).booleanValue() && Utils.Numbers.gte((Number)instance, schema.get("maximum")) || Utils.Numbers.gt((Number)instance, schema.get("maximum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, "maximum", schemaLocation + "/maximum", instance + " is greater than " + (schema.get("exclusiveMaximum", false) != false ? "or equal to " : "") + schema.get("maximum")));
                                                }
                                            } else {
                                                if (schema.containsKey("minimum") && Utils.Numbers.lt((Number)instance, schema.get("minimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, "minimum", schemaLocation + "/minimum", instance + " is less than " + schema.get("minimum")));
                                                }
                                                if (schema.containsKey("maximum") && Utils.Numbers.gt((Number)instance, schema.get("maximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, "maximum", schemaLocation + "/maximum", instance + " is greater than " + schema.get("maximum")));
                                                }
                                                if (schema.containsKey("exclusiveMinimum") && Utils.Numbers.lte((Number)instance, schema.get("exclusiveMinimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, "exclusiveMinimum", schemaLocation + "/exclusiveMinimum", instance + " is less than or equal to " + schema.get("exclusiveMinimum")));
                                                }
                                                if (schema.containsKey("exclusiveMaximum") && Utils.Numbers.gte((Number)instance, schema.get("exclusiveMaximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, "exclusiveMaximum", schemaLocation + "/exclusiveMaximum", instance + " is greater than or equal to " + schema.get("exclusiveMaximum")));
                                                }
                                            }
                                            if (schema.containsKey("multipleOf") && Math.abs(0.0 - (remainder = Utils.Numbers.remainder((Number)instance, (Number)schema.get("multipleOf")))) >= 1.1920929E-7 && Math.abs(((Number)schema.get("multipleOf")).doubleValue() - remainder) >= 1.1920929E-7) {
                                                errors.add(new OutputUnit(instanceLocation, "multipleOf", schemaLocation + "/multipleOf", instance + " is not a multiple of " + schema.get("multipleOf")));
                                            }
                                            break block140;
                                        }
                                        case "string": {
                                            int length3;
                                            int n = length3 = !schema.containsKey("minLength") && !schema.containsKey("maxLength") ? 0 : Utils.Strings.ucs2length((String)instance);
                                            if (schema.containsKey("minLength") && Utils.Numbers.lt(length3, schema.get("minLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, "minLength", schemaLocation + "/minLength", "String is too short (" + length3 + " < " + schema.get("minLength") + ")"));
                                            }
                                            if (schema.containsKey("maxLength") && Utils.Numbers.gt(length3, schema.get("maxLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, "maxLength", schemaLocation + "/maxLength", "String is too long (" + length3 + " > " + schema.get("maxLength") + ")"));
                                            }
                                            if (schema.containsKey("pattern") && !Pattern.compile((String)schema.get("pattern")).matcher((String)instance).find()) {
                                                errors.add(new OutputUnit(instanceLocation, "pattern", schemaLocation + "/pattern", "String does not match pattern"));
                                            }
                                            if (schema.containsKey("format") && !Format.fastFormat((String)schema.get("format"), (String)instance)) {
                                                errors.add(new OutputUnit(instanceLocation, "format", schemaLocation + "/format", "String does not match format \"" + schema.get("format") + "\""));
                                            }
                                            break block140;
                                        }
                                        default: {
                                            break block140;
                                        }
                                    }
                                    if (stop2 || !schema.containsKey("additionalProperties")) break block147;
                                    keywordLocation = schemaLocation + "/additionalProperties";
                                    propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                    break block148;
                                }
                                if (stop2 || !schema.containsKey("unevaluatedProperties")) break block140;
                                keywordLocation = schemaLocation + "/unevaluatedProperties";
                                propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                break block149;
                            }
                            while (propsOrSchema.hasNext()) {
                                key5 = (String)propsOrSchema.next();
                                if (thisEvaluated.contains(key5)) continue;
                                subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key5);
                                result2 = this.validate(((JsonObject)instance).getValue(key5), Utils.Schemas.wrap((JsonObject)schema, "additionalProperties"), recursiveAnchor, subInstancePointer, keywordLocation, new HashSet<Object>());
                                if (((OutputUnit)result2).getValid().booleanValue()) {
                                    evaluated.add(key5);
                                    continue;
                                }
                                stop2 = this.outputFormat == OutputFormat.Flag;
                                errors.add(new OutputUnit(instanceLocation, "additionalProperties", keywordLocation, "Property \"" + key5 + "\" does not match additional properties schema"));
                                if (((OutputUnit)result2).getErrors() == null) continue;
                                errors.addAll(((OutputUnit)result2).getErrors());
                            }
                            break block140;
                        }
                        while (propsOrSchema.hasNext()) {
                            key5 = (String)propsOrSchema.next();
                            if (evaluated.contains(key5)) continue;
                            subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key5);
                            result2 = this.validate(((JsonObject)instance).getValue(key5), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedProperties"), recursiveAnchor, subInstancePointer, keywordLocation, new HashSet<Object>());
                            if (((OutputUnit)result2).getValid().booleanValue()) {
                                evaluated.add(key5);
                                continue;
                            }
                            errors.add(new OutputUnit(instanceLocation, "unevaluatedProperties", keywordLocation, "Property \"" + key5 + "\" does not match unevaluated properties schema"));
                            if (((OutputUnit)result2).getErrors() == null) continue;
                            errors.addAll(((OutputUnit)result2).getErrors());
                        }
                        break block140;
                    }
                    while (i < length) {
                        OutputUnit result10 = this.validate(((JsonArray)instance).getValue(i), Utils.Schemas.wrap((JsonObject)schema, "items"), recursiveAnchor, instanceLocation + "/" + i, keywordLocation, new HashSet<Object>());
                        evaluated.add(i);
                        if (!result10.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, "items", keywordLocation, "Items did not match schema"));
                            if (result10.getErrors() != null) {
                                errors.addAll(result10.getErrors());
                            }
                            if (stop) break;
                        }
                        ++i;
                    }
                }
                if (!stop && schema.containsKey("additionalItems")) {
                    String keywordLocation2 = schemaLocation + "/additionalItems";
                    while (i < length) {
                        result = this.validate(((JsonArray)instance).getValue(i), Utils.Schemas.wrap((JsonObject)schema, "additionalItems"), recursiveAnchor, instanceLocation + "/" + i, keywordLocation2, new HashSet<Object>());
                        evaluated.add(i);
                        if (!result.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, "additionalItems", keywordLocation2, "Items did not match additional items schema"));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                        ++i;
                    }
                }
            }
            if (schema.containsKey("contains")) {
                if (length == 0 && !schema.containsKey("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, "contains", schemaLocation + "/contains", "Array is empty. It must contain at least one item matching the schema"));
                } else if (schema.containsKey("minContains") && length < (Integer)schema.get("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, "minContains", schemaLocation + "/minContains", "Array has less items (" + length + ") than minContains (" + schema.get("minContains") + ")"));
                } else {
                    keywordLocation = schemaLocation + "/contains";
                    int errorsLength = errors.size();
                    int contained = 0;
                    for (int j = 0; j < length; ++j) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue(j), Utils.Schemas.wrap((JsonObject)schema, "contains"), recursiveAnchor, instanceLocation + "/" + i, keywordLocation, new HashSet<Object>());
                        if (result.getValid().booleanValue()) {
                            evaluated.add(j);
                            ++contained;
                            continue;
                        }
                        if (result.getErrors() == null) continue;
                        errors.addAll(result.getErrors());
                    }
                    if (contained >= schema.get("minContains", 0)) {
                        errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                    }
                    if (!schema.containsKey("minContains") && !schema.containsKey("maxContains") && contained == 0) {
                        errors.add(errorsLength, new OutputUnit(instanceLocation, "contains", keywordLocation, "Array does not contain item matching schema"));
                    } else if (schema.containsKey("minContains") && contained < (Integer)schema.get("minContains")) {
                        errors.add(new OutputUnit(instanceLocation, "minContains", keywordLocation + "/minContains", "Array must contain at least " + schema.get("minContains") + " items matching schema. Only " + contained + " items were found"));
                    } else if (schema.containsKey("maxContains") && contained > (Integer)schema.get("maxContains")) {
                        errors.add(new OutputUnit(instanceLocation, "maxContains", keywordLocation + "/maxContains", "Array may contain at most " + schema.get("minContains") + " items matching schema. " + contained + " items were found"));
                    }
                }
            }
            if (!stop && schema.containsKey("unevaluatedItems")) {
                keywordLocation = schemaLocation + "/unevaluatedItems";
                while (i < length) {
                    if (!evaluated.contains(i)) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue(i), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedItems"), recursiveAnchor, instanceLocation + "/" + i, keywordLocation, new HashSet<Object>());
                        evaluated.add(i);
                        if (!result.getValid().booleanValue()) {
                            errors.add(new OutputUnit(instanceLocation, "unevaluatedItems", keywordLocation, "Items did not match unevaluated items schema"));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                    }
                    ++i;
                }
            }
            if (schema.containsKey("uniqueItems") && Utils.Objects.truthy(schema.get("uniqueItems"))) {
                for (int j = 0; j < length; ++j) {
                    Object a = ((JsonArray)instance).getValue(j);
                    boolean ao = "object".equals(Utils.JSON.typeOf(a)) && a != null;
                    for (int k = 0; k < length; ++k) {
                        boolean bo;
                        if (j == k) continue;
                        Object b = ((JsonArray)instance).getValue(k);
                        boolean bl = bo = "object".equals(Utils.JSON.typeOf(b)) && b != null;
                        if (!Utils.Objects.equals(a, b) && (!ao || !bo || !Utils.JSON.deepCompare(a, b))) continue;
                        errors.add(new OutputUnit(instanceLocation, "uniqueItems", schemaLocation + "/uniqueItems", "Duplicate items at indexes " + j + " and " + k));
                        break block140;
                    }
                }
            }
        }
        OutputUnit outputUnit = new OutputUnit(errors.isEmpty()).setErrors(errors.isEmpty() ? null : errors);
        if (annotations.isEmpty()) {
            arrayList = null;
            return outputUnit.setAnnotations(arrayList);
        }
        arrayList = annotations;
        return outputUnit.setAnnotations(arrayList);
    }
}

