/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.URIUtils;
import io.vertx.json.schema.common.ValidatorContext;
import java.net.URI;

public class RefSchema
extends SchemaImpl {
    private static final Logger log = LoggerFactory.getLogger(RefSchema.class);
    private final JsonPointer refPointer;
    private final SchemaParser schemaParser;
    private SchemaInternal cachedSchema;
    private final boolean executeSchemaValidators;

    public RefSchema(JsonObject schema, JsonPointer scope, SchemaParser schemaParser, MutableStateValidator parent, boolean executeSchemaValidators) {
        super(schema, scope, parent);
        this.schemaParser = schemaParser;
        this.executeSchemaValidators = executeSchemaValidators;
        try {
            String unparsedUri = schema.getString("$ref");
            this.refPointer = URIUtils.createJsonPointerFromURI(URI.create(unparsedUri));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Parsed %s ref for schema %s", this.refPointer, schema));
            }
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null $ref keyword", e);
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for $ref keyword", e);
        }
        catch (IllegalArgumentException e) {
            throw new SchemaException(schema, "$ref URI is invalid: " + e.getMessage(), e);
        }
    }

    private void registerCachedSchema(SchemaInternal s) {
        this.cachedSchema = s;
        if (s instanceof SchemaImpl) {
            ((SchemaImpl)s).registerReferredSchema(this);
        }
    }

    @Override
    public Future<Void> validateAsync(ValidatorContext inContext, Object in) {
        if (this.isSync()) {
            return this.validateSyncAsAsync(inContext, in);
        }
        ValidatorContext context = this.generateValidationContext(inContext);
        if (this.cachedSchema == null) {
            Future fut = this.schemaParser.getSchemaRouter().resolveRef(this.refPointer, this.getScope(), this.schemaParser).compose(s -> {
                if (s == null) {
                    return Future.failedFuture((Throwable)((Object)ValidationException.create("Cannot resolve reference " + this.refPointer.toURI(), "$ref", in)));
                }
                SchemaInternal solvedSchema = (SchemaInternal)s;
                this.registerCachedSchema(solvedSchema);
                if (solvedSchema instanceof RefSchema) {
                    return solvedSchema.validateAsync(context, in).compose(v -> {
                        this.triggerUpdateIsSync();
                        return Future.succeededFuture();
                    });
                }
                this.triggerUpdateIsSync();
                return solvedSchema.validateAsync(context, in);
            }, err -> Future.failedFuture((Throwable)((Object)ValidationException.create("Error while resolving reference " + this.refPointer.toURI(), "$ref", in, err))));
            if (this.executeSchemaValidators) {
                return fut.compose(v -> this.runAsyncValidators(context, in));
            }
            return fut;
        }
        if (this.executeSchemaValidators) {
            return this.cachedSchema.validateAsync(context, in).compose(v -> this.runAsyncValidators(context, in));
        }
        return this.cachedSchema.validateAsync(context, in);
    }

    @Override
    public void validateSync(ValidatorContext context, Object in) throws ValidationException {
        this.checkSync();
        context = this.generateValidationContext(context);
        this.cachedSchema.validateSync(context, in);
        if (this.executeSchemaValidators) {
            this.runSyncValidator(context, in);
        }
    }

    @Override
    public boolean calculateIsSync() {
        return (!this.executeSchemaValidators || super.calculateIsSync()) && this.cachedSchema != null && this.cachedSchema.isSync();
    }

    @Override
    protected void initializeIsSync() {
        this.isSync = false;
    }

    @Override
    public Future<Object> getOrApplyDefaultAsync(Object input) {
        if (this.isSync()) {
            return Future.succeededFuture((Object)this.getOrApplyDefaultSync(input));
        }
        return this.trySolveSchema().compose(schemaInternal -> schemaInternal.getOrApplyDefaultAsync(input));
    }

    @Override
    public Object getOrApplyDefaultSync(Object input) {
        this.checkSync();
        return this.cachedSchema.getOrApplyDefaultSync(input);
    }

    synchronized Future<SchemaInternal> trySolveSchema() {
        if (this.cachedSchema == null) {
            return this.schemaParser.getSchemaRouter().resolveRef(this.refPointer, this.getScope(), this.schemaParser).compose(s -> {
                if (s == null) {
                    return Future.failedFuture((Throwable)((Object)ValidationException.create("Cannot resolve reference " + this.refPointer.toURI(), "$ref", null)));
                }
                this.registerCachedSchema((SchemaInternal)s);
                if (s instanceof RefSchema) {
                    return ((RefSchema)s).trySolveSchema().map(s1 -> {
                        this.triggerUpdateIsSync();
                        return this.cachedSchema;
                    });
                }
                this.triggerUpdateIsSync();
                return Future.succeededFuture((Object)this.cachedSchema);
            }, err -> Future.failedFuture((Throwable)((Object)ValidationException.create("Error while resolving reference " + this.refPointer.toURI(), "$ref", null, err))));
        }
        return Future.succeededFuture((Object)this.cachedSchema);
    }

    void prePropagateSyncState() {
        this.isSync = true;
        if (this.getParent() != null) {
            this.getParent().triggerUpdateIsSync();
        }
    }

    void setIsSync(boolean s) {
        this.isSync = s;
        if (this.getParent() != null) {
            this.getParent().triggerUpdateIsSync();
        }
    }
}

