/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.Map;

public class DefinitionsValidatorFactory
implements ValidatorFactory {
    private final String definitionsKey;

    public DefinitionsValidatorFactory(String definitionsKey) {
        this.definitionsKey = definitionsKey;
    }

    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            JsonObject definitions = schema.getJsonObject(this.definitionsKey);
            JsonPointer basePointer = scope.append(this.definitionsKey);
            definitions.forEach(e -> parser.parse(e.getValue() instanceof Map ? new JsonObject((Map)e.getValue()) : e.getValue(), basePointer.copy().append((String)e.getKey()), null));
            return null;
        }
        catch (ClassCastException e2) {
            throw new SchemaException(schema, "Wrong type for " + this.definitionsKey + " keyword", e2);
        }
        catch (NullPointerException e3) {
            throw new SchemaException(schema, "Null " + this.definitionsKey + " keyword", e3);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey(this.definitionsKey);
    }
}

