/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.ComparisonUtils;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;

public class ConstValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        Object allowedValue = schema.getValue("const");
        return new ConstValidator(allowedValue);
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("const");
    }

    public static class ConstValidator
    extends BaseSyncValidator {
        private final Object allowedValue;

        public ConstValidator(Object allowedValue) {
            this.allowedValue = allowedValue;
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.MAX_PRIORITY;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (!ComparisonUtils.equalsNumberSafe(this.allowedValue, in)) {
                throw ValidationException.create("Input doesn't match const: " + this.allowedValue, "const", in);
            }
        }
    }
}

