/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.CallableOutParams;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCTypeWrapper;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collector;

public class JDBCPreparedQuery<C, R>
extends JDBCQueryAction<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final Tuple params = Tuple.tuple();
    private final CallableOutParams outParams = CallableOutParams.create();

    public JDBCPreparedQuery(JDBCStatementHelper helper, SQLOptions options, ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, Tuple params) {
        super(helper, options, collector);
        this.query = query;
        this.normalizeParams(params);
    }

    @Override
    public JDBCResponse<R> execute(Connection conn) throws SQLException {
        boolean returnAutoGeneratedKeys = this.outParams.size() == 0 && this.returnAutoGeneratedKeys(conn);
        try (PreparedStatement ps = this.prepare(conn, returnAutoGeneratedKeys);){
            this.fillStatement(ps, conn);
            JDBCResponse jDBCResponse = this.decode(ps, ps.execute(), returnAutoGeneratedKeys, this.outParams);
            return jDBCResponse;
        }
    }

    private PreparedStatement prepare(Connection conn, boolean returnAutoGeneratedKeys) throws SQLException {
        boolean autoGeneratedIndexes;
        String sql = this.query.sql();
        if (!this.outParams.isEmpty()) {
            return conn.prepareCall(sql);
        }
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (returnAutoGeneratedKeys && !autoGeneratedIndexes) {
            return conn.prepareStatement(sql, 1);
        }
        if (autoGeneratedIndexes) {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            try {
                if (indexes.getValue(0) instanceof Number) {
                    int[] keys = new int[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getInteger(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                if (indexes.getValue(0) instanceof String) {
                    String[] keys = new String[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getString(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                throw new SQLException("Invalid type of index, only [int, String] allowed");
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
        }
        return conn.prepareStatement(sql);
    }

    private void normalizeParams(Tuple tuple) {
        if (tuple == null) {
            return;
        }
        for (int i = 0; i < tuple.size(); ++i) {
            Object param = tuple.getValue(i);
            if (param instanceof SqlOutParam) {
                SqlOutParam out = (SqlOutParam)param;
                this.outParams.put((Integer)(i + 1), out.type());
                this.params.addValue(out.in() ? out.value() : out);
                continue;
            }
            this.params.addValue(param);
        }
    }

    private void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        if (!this.outParams.isEmpty()) {
            CallableStatement cs = (CallableStatement)ps;
            for (Map.Entry entry : this.outParams.entrySet()) {
                cs.registerOutParameter((int)((Integer)entry.getKey()), ((JDBCTypeWrapper)entry.getValue()).vendorTypeNumber());
            }
        }
        ParameterMetaData metaData = ps.getParameterMetaData();
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(metaData);
        for (int idx = 1; idx <= this.params.size(); ++idx) {
            Object value = this.params.getValue(idx - 1);
            if (value instanceof SqlOutParam) continue;
            ps.setObject(idx, this.adaptType(conn, this.helper.getEncoder().encode(this.params, idx, provider)));
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof Buffer) {
            Buffer buffer = (Buffer)value;
            Blob blob = conn.createBlob();
            blob.setBytes(1L, buffer.getBytes());
            return blob;
        }
        return value;
    }
}

