/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.jdbcclient.JDBCPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import java.util.ArrayList;
import java.util.List;

public class JDBCResponse<R> {
    private int update;
    private List<RS> rs;
    private Row ids;
    private List<RS> output;
    private R empty;

    public JDBCResponse(int updateCount) {
        this.update = updateCount;
    }

    public void push(R decodeResultSet, RowDesc desc, int size) {
        if (this.rs == null) {
            this.rs = new ArrayList<RS>();
        }
        this.rs.add(new RS<R>(decodeResultSet, desc, size));
    }

    public void returnedKeys(Row keys) {
        this.ids = keys;
    }

    public void empty(R apply) {
        this.empty = apply;
    }

    public void outputs(R decodeResultSet, RowDesc desc, int size) {
        if (this.output == null) {
            this.output = new ArrayList<RS>();
        }
        this.output.add(new RS<R>(decodeResultSet, desc, size));
    }

    public void handle(QueryResultHandler<R> handler) {
        if (this.rs != null) {
            for (RS rs : this.rs) {
                handler.handleResult(this.update, rs.size, rs.desc, rs.holder, null);
                if (this.ids == null) continue;
                handler.addProperty(JDBCPool.GENERATED_KEYS, (Object)this.ids);
            }
        }
        if (this.output != null) {
            for (RS rs : this.output) {
                handler.handleResult(this.update, rs.size, null, rs.holder, null);
                handler.addProperty(JDBCPool.OUTPUT, (Object)true);
            }
        }
        if (this.rs == null && this.output == null) {
            handler.handleResult(this.update, -1, null, this.empty, null);
            if (this.ids != null) {
                handler.addProperty(JDBCPool.GENERATED_KEYS, (Object)this.ids);
            }
        }
    }

    static class RS<R> {
        R holder;
        int size;
        RowDesc desc;

        RS(R holder, RowDesc desc, int size) {
            this.holder = holder;
            this.desc = desc;
            this.size = size;
        }
    }
}

