/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.JDBCRow;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class JDBCQueryAction<C, R>
extends AbstractJDBCAction<JDBCResponse<R>> {
    private final Collector<Row, C, R> collector;

    public JDBCQueryAction(JDBCStatementHelper helper, SQLOptions options, Collector<Row, C, R> collector) {
        super(helper, options);
        this.collector = collector;
    }

    protected JDBCResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys, List<Integer> out) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
        }
        if (returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        if (out.size() > 0) {
            this.decodeOutput((CallableStatement)statement, out, response);
        }
        return response;
    }

    protected JDBCResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        RowDesc desc = new RowDesc(Collections.emptyList());
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            JDBCRow row = new JDBCRow(desc);
            row.addValue(result);
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, JDBCResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        int size = 0;
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            ++size;
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCQueryAction.convertSqlValue(rs.getObject(i));
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private R decodeRawResultSet(ResultSet rs) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCQueryAction.convertSqlValue(rs.getObject(i));
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        return this.collector.finisher().apply(container);
    }

    private void decodeOutput(CallableStatement cs, List<Integer> out, JDBCResponse<R> output) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        JDBCRow row = new JDBCRow(new RowDesc(Collections.emptyList()));
        for (Integer idx : out) {
            if (cs.getObject(idx) instanceof ResultSet) {
                row.addValue(this.decodeRawResultSet((ResultSet)cs.getObject(idx)));
                continue;
            }
            Object res = JDBCQueryAction.convertSqlValue(cs.getObject(idx));
            row.addValue(res);
        }
        accumulator.accept(container, row);
        R result = this.collector.finisher().apply(container);
        output.outputs(result, null, 1);
    }

    private void decodeReturnedKeys(Statement statement, JDBCResponse<R> response) throws SQLException {
        JDBCRow keys = null;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null) {
            int i;
            ArrayList<String> keysColumnNames = new ArrayList<String>();
            RowDesc keysDesc = new RowDesc(keysColumnNames);
            ResultSetMetaData metaData = keysRS.getMetaData();
            int cols = metaData.getColumnCount();
            for (i = 1; i <= cols; ++i) {
                keysColumnNames.add(metaData.getColumnLabel(i));
            }
            if (keysRS.next()) {
                keys = new JDBCRow(keysDesc);
                for (i = 1; i <= cols; ++i) {
                    Object res = JDBCQueryAction.convertSqlValue(keysRS.getObject(i));
                    keys.addValue(res);
                }
            }
        }
        response.returnedKeys(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertSqlValue(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toInstant().atOffset(ZoneOffset.UTC);
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String string = c.getSubString(1L, (int)c.length());
                return string;
            }
            finally {
                try {
                    c.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] byArray = b.getBytes(1L, (int)b.length());
                return byArray;
            }
            finally {
                try {
                    b.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Array) {
            Array a = (Array)value;
            try {
                Object[] arr = (Object[])a.getArray();
                if (arr != null) {
                    Object[] castedArray = new Object[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        castedArray[i] = JDBCQueryAction.convertSqlValue(arr[i]);
                    }
                    Object[] objectArray = castedArray;
                    return objectArray;
                }
            }
            finally {
                a.free();
            }
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        return value.toString();
    }
}

