/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.ResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JDBCQuery
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final int timeout;

    public JDBCQuery(Vertx vertx, JDBCStatementHelper helper, Connection connection, WorkerExecutor exec, int timeout, String sql, JsonArray in) {
        super(vertx, helper, connection, exec);
        this.sql = sql;
        this.in = in;
        this.timeout = timeout;
    }

    @Override
    protected ResultSet execute() throws SQLException {
        try (PreparedStatement statement = this.conn.prepareStatement(this.sql);){
            if (this.timeout >= 0) {
                statement.setQueryTimeout(this.timeout);
            }
            this.helper.fillStatement(statement, this.in);
            boolean retResult = statement.execute();
            ResultSet resultSet = null;
            if (retResult) {
                ResultSet ref = null;
                while (retResult) {
                    try (java.sql.ResultSet rs = statement.getResultSet();){
                        if (ref == null) {
                            ref = resultSet = this.helper.asList(rs);
                        } else {
                            ref.setNext(this.helper.asList(rs));
                            ref = ref.getNext();
                        }
                    }
                    retResult = statement.getMoreResults();
                }
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
    }

    @Override
    protected String name() {
        return "query";
    }
}

