/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.cache;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.httpproxy.cache.CacheOptionsConverter;
import io.vertx.httpproxy.impl.CacheImpl;
import io.vertx.httpproxy.spi.cache.Cache;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class CacheOptions {
    public static final int DEFAULT_MAX_SIZE = 1000;
    private int maxSize = 1000;

    public CacheOptions() {
    }

    public CacheOptions(JsonObject json) {
        CacheOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public CacheOptions setMaxSize(int maxSize) {
        Arguments.require((maxSize > 0 ? 1 : 0) != 0, (String)"Max size must be > 0");
        this.maxSize = maxSize;
        return this;
    }

    public <K, V> Cache<K, V> newCache() {
        return new CacheImpl(this);
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CacheOptionsConverter.toJson(this, json);
        return json;
    }
}

