/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.client;

import io.grpc.ClientCall;
import io.grpc.Compressor;
import io.grpc.Deadline;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.GrpcErrorException;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.VertxScheduledExecutorService;
import io.vertx.grpc.common.impl.WriteStreamAdapter;
import io.vertx.grpcio.client.GrpcIoClient;
import io.vertx.grpcio.common.impl.BridgeMessageDecoder;
import io.vertx.grpcio.common.impl.BridgeMessageEncoder;
import io.vertx.grpcio.common.impl.ReadStreamAdapter;
import io.vertx.grpcio.common.impl.Utils;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class VertxClientCall<RequestT, ResponseT>
extends ClientCall<RequestT, ResponseT> {
    private final GrpcIoClient client;
    private final SocketAddress server;
    private final Executor exec;
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final String encoding;
    private final Compressor compressor;
    private final Deadline deadline;
    private Future<GrpcClientRequest<RequestT, ResponseT>> fut;
    private ClientCall.Listener<ResponseT> listener;
    private WriteStreamAdapter<RequestT> writeAdapter;
    private ReadStreamAdapter<ResponseT> readAdapter;
    private GrpcClientRequest<RequestT, ResponseT> request;
    private GrpcClientResponse<RequestT, ResponseT> grpcResponse;

    VertxClientCall(GrpcIoClient client, SocketAddress server, final Executor exec, MethodDescriptor<RequestT, ResponseT> methodDescriptor, String encoding, Compressor compressor, Deadline deadline) {
        this.client = client;
        this.server = server;
        this.exec = exec;
        this.methodDescriptor = methodDescriptor;
        this.encoding = encoding;
        this.compressor = compressor;
        this.deadline = deadline;
        this.writeAdapter = new WriteStreamAdapter<RequestT>(){

            protected void handleReady() {
                VertxClientCall.this.listener.onReady();
            }
        };
        this.readAdapter = new ReadStreamAdapter<ResponseT>(){

            protected void handleMessage(ResponseT msg) {
                if (exec == null) {
                    VertxClientCall.this.listener.onMessage(msg);
                } else {
                    exec.execute(() -> VertxClientCall.this.listener.onMessage(msg));
                }
            }
        };
    }

    public boolean isReady() {
        return this.writeAdapter.isReady();
    }

    public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
        this.listener = responseListener;
        this.fut = this.client.request((Address)this.server, this.methodDescriptor);
        this.fut.onComplete(ar1 -> {
            if (ar1.succeeded()) {
                ScheduledFuture sf;
                this.request = (GrpcClientRequest)ar1.result();
                Utils.writeMetadata((Metadata)headers, (MultiMap)this.request.headers());
                if (this.deadline != null) {
                    long timeout = this.deadline.timeRemaining(TimeUnit.MILLISECONDS);
                    this.request.timeout(timeout, TimeUnit.MILLISECONDS);
                    sf = this.deadline.runOnExpiration(() -> this.request.cancel(), (ScheduledExecutorService)new VertxScheduledExecutorService((Context)((GrpcClientRequestImpl)this.request).context()));
                } else {
                    sf = null;
                }
                if (this.encoding != null) {
                    this.request.encoding(this.encoding);
                }
                Future responseFuture = this.request.response();
                responseFuture.onComplete(ar2 -> {
                    if (ar2.succeeded()) {
                        boolean trailersOnly;
                        this.grpcResponse = (GrpcClientResponse)ar2.result();
                        boolean bl = trailersOnly = this.grpcResponse.status() != null;
                        if (sf != null) {
                            this.grpcResponse.end().onComplete(ar -> sf.cancel(false));
                        }
                        String respEncoding = this.grpcResponse.encoding();
                        Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(respEncoding);
                        BridgeMessageDecoder decoder = new BridgeMessageDecoder(this.methodDescriptor.getResponseMarshaller(), decompressor);
                        Metadata responseHeaders = Utils.readMetadata((MultiMap)this.grpcResponse.headers());
                        if (this.exec == null) {
                            responseListener.onHeaders(responseHeaders);
                        } else {
                            this.exec.execute(() -> responseListener.onHeaders(responseHeaders));
                        }
                        this.readAdapter.init(this.grpcResponse, decoder);
                        this.grpcResponse.end().onComplete(ar -> {
                            Metadata trailers;
                            Status status;
                            if (this.grpcResponse.status() != null) {
                                status = Status.fromCodeValue((int)this.grpcResponse.status().code);
                                if (this.grpcResponse.statusMessage() != null) {
                                    status = status.withDescription(this.grpcResponse.statusMessage());
                                }
                                trailers = Utils.readMetadata((MultiMap)(trailersOnly ? this.grpcResponse.headers() : this.grpcResponse.trailers()));
                            } else {
                                status = Status.fromThrowable((Throwable)ar.cause());
                                trailers = new Metadata();
                            }
                            this.doClose(status, trailers);
                        });
                    } else {
                        Throwable err = ar2.cause();
                        if (err instanceof GrpcErrorException) {
                            GrpcErrorException reset = (GrpcErrorException)err;
                            this.doClose(Status.fromCodeValue((int)reset.status().code), new Metadata());
                        } else {
                            this.doClose(Status.fromThrowable((Throwable)err), new Metadata());
                        }
                    }
                });
                this.writeAdapter.init(this.request, WireFormat.PROTOBUF, (GrpcMessageEncoder)new BridgeMessageEncoder(this.methodDescriptor.getRequestMarshaller(), this.compressor));
            } else {
                this.doClose(Status.UNAVAILABLE, new Metadata());
            }
        });
    }

    private void doClose(Status status, Metadata trailers) {
        Runnable cmd = () -> this.listener.onClose(status, trailers);
        if (this.exec == null) {
            cmd.run();
        } else {
            this.exec.execute(cmd);
        }
    }

    public void request(int numMessages) {
        this.readAdapter.request(numMessages);
    }

    public void cancel(String message, Throwable cause) {
        this.fut.onSuccess(req -> req.cancel());
    }

    public void halfClose() {
        this.fut.onSuccess(req -> req.end());
    }

    public void sendMessage(RequestT message) {
        this.fut.onSuccess(v -> this.writeAdapter.write(message));
    }
}

