/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpcio.client.GrpcIoClient;
import io.vertx.grpcio.client.VertxClientCall;
import java.util.concurrent.Executor;

public class GrpcIoClientChannel
extends Channel {
    private GrpcIoClient client;
    private SocketAddress server;

    public GrpcIoClientChannel(GrpcClient client, SocketAddress server) {
        this.client = (GrpcIoClient)client;
        this.server = server;
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        String encoding = callOptions.getCompressor();
        Compressor compressor = encoding != null ? CompressorRegistry.getDefaultInstance().lookupCompressor(encoding) : null;
        Executor exec = callOptions.getExecutor();
        Context ctx = Context.current();
        Deadline deadline = callOptions.getDeadline();
        Deadline contextDeadline = ctx.getDeadline();
        if (contextDeadline != null && (deadline == null || contextDeadline.isBefore(deadline))) {
            deadline = contextDeadline;
        }
        return new VertxClientCall<RequestT, ResponseT>(this.client, this.server, exec, methodDescriptor, encoding, compressor, deadline);
    }

    public String authority() {
        return null;
    }
}

