/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.impl;

import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.grpc.GrpcWriteStream;

public class GrpcWriteStreamImpl<T>
implements GrpcWriteStream<T> {
    private final StreamObserver<T> observer;
    private final Handler<Throwable> errHandler;

    public GrpcWriteStreamImpl(StreamObserver<T> observer) {
        this.observer = observer;
        this.errHandler = arg_0 -> observer.onError(arg_0);
    }

    @Override
    public GrpcWriteStreamImpl<T> exceptionHandler(Handler<Throwable> handler) {
        handler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    public void write(T data, Handler<AsyncResult<Void>> handler) {
        this.observer.onNext(data);
        handler.handle((Object)Future.succeededFuture());
    }

    public Future<Void> write(T t) {
        this.observer.onNext(t);
        return Future.succeededFuture();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.observer.onCompleted();
        handler.handle((Object)Future.succeededFuture());
    }

    @Override
    public GrpcWriteStreamImpl<T> setWriteQueueMaxSize(int i) {
        this.errHandler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public GrpcWriteStreamImpl<T> drainHandler(Handler<Void> handler) {
        this.errHandler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    @Override
    public GrpcWriteStreamImpl<T> fail(Throwable t) {
        this.observer.onError(t);
        return this;
    }

    @Override
    public StreamObserver<T> writeObserver() {
        return this.observer;
    }
}

