/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.impl;

import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.GrpcBidiExchange;
import io.vertx.grpc.GrpcReadStream;
import io.vertx.grpc.GrpcWriteStream;

public class GrpcBidiExchangeImpl<I, O>
implements GrpcBidiExchange<I, O> {
    private final GrpcReadStream<I> readStream;
    private final GrpcWriteStream<O> writeStream;

    public GrpcBidiExchangeImpl(GrpcReadStream<I> readStream, StreamObserver<O> writeObserver) {
        this.readStream = readStream;
        this.writeStream = GrpcWriteStream.create(writeObserver);
    }

    public GrpcBidiExchangeImpl(StreamObserver<I> readObserver, StreamObserver<O> writeObserver) {
        this.readStream = GrpcReadStream.create(readObserver);
        this.writeStream = GrpcWriteStream.create(writeObserver);
    }

    @Override
    public GrpcBidiExchange<I, O> exceptionHandler(Handler<Throwable> handler) {
        this.readStream.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> write(O data) {
        this.writeStream.write((Object)data);
        return this;
    }

    public WriteStream<O> write(O data, Handler<AsyncResult<Void>> handler) {
        this.writeStream.write(data, handler);
        return this;
    }

    public void end() {
        this.writeStream.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.writeStream.end(handler);
    }

    @Override
    public GrpcBidiExchange<I, O> setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.writeStream.writeQueueFull();
    }

    @Override
    public GrpcBidiExchange<I, O> drainHandler(Handler<Void> handler) {
        this.writeStream.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> fail(Throwable t) {
        this.writeStream.fail(t);
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> handler(Handler<I> handler) {
        this.readStream.handler((Handler)handler);
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> pause() {
        this.readStream.pause();
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> resume() {
        this.readStream.resume();
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> fetch(long amount) {
        this.readStream.fetch(amount);
        return this;
    }

    @Override
    public GrpcBidiExchange<I, O> endHandler(Handler<Void> handler) {
        this.readStream.endHandler((Handler)handler);
        return this;
    }

    @Override
    public StreamObserver<I> readObserver() {
        return this.readStream.readObserver();
    }

    @Override
    public GrpcBidiExchange<I, O> setReadObserver(StreamObserver<I> observer) {
        this.readStream.setReadObserver(observer);
        return this;
    }

    @Override
    public StreamObserver<O> writeObserver() {
        return this.writeStream.writeObserver();
    }
}

