/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc;

import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.SslContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.transport.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;

public class VertxServer
extends Server {
    private static final ConcurrentMap<ServerID, ActualServer> map = new ConcurrentHashMap<ServerID, ActualServer>();
    private final ServerID id;
    private final NettyServerBuilder builder;
    private final HttpServerOptions options;
    private ActualServer actual;
    private final ContextInternal context;
    private Closeable hook;

    VertxServer(ServerID id, HttpServerOptions options, NettyServerBuilder builder, ContextInternal context) {
        this.id = id;
        this.options = options;
        this.builder = builder;
        this.context = context;
    }

    public VertxServer start() throws IOException {
        return this.start((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public VertxServer start(Handler<AsyncResult<Void>> completionHandler) {
        this.actual = this.id.port > 0 ? map.computeIfAbsent(this.id, id -> new ActualServer((Vertx)this.context.owner(), (ServerID)id, this.options, this.builder)) : new ActualServer((Vertx)this.context.owner(), this.id, this.options, this.builder);
        this.actual.start(this.context, (Handler<AsyncResult<Void>>)((Handler)ar1 -> {
            if (ar1.succeeded()) {
                this.hook = ar2 -> this.shutdown((Handler<AsyncResult<Void>>)ar2);
                this.context.addCloseHook(this.hook);
            }
            completionHandler.handle(ar1);
        }));
        return this;
    }

    public VertxServer shutdown() {
        return this.shutdown((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public VertxServer shutdown(Handler<AsyncResult<Void>> completionHandler) {
        if (this.hook != null) {
            this.context.removeCloseHook(this.hook);
        }
        this.actual.stop(this.context, completionHandler);
        return this;
    }

    public int getPort() {
        return this.actual.server.getPort();
    }

    public VertxServer shutdownNow() {
        throw new UnsupportedOperationException();
    }

    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isTerminated() {
        return this.actual.server.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.actual.server.awaitTermination(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.actual.server.awaitTermination();
    }

    private static class ActualServer {
        final ServerID id;
        final HttpServerOptions options;
        final AtomicInteger count = new AtomicInteger();
        final VertxEventLoopGroup group = new VertxEventLoopGroup();
        final HandlerManager<String> manager = new HandlerManager(this.group);
        final Server server;
        final ThreadLocal<List<ContextInternal>> contextLocal = new ThreadLocal();

        private ActualServer(Vertx vertx, ServerID id, HttpServerOptions options, NettyServerBuilder builder) {
            if (options.isSsl()) {
                final SSLHelper helper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
                helper.setApplicationProtocols(Collections.singletonList(HttpVersion.HTTP_2));
                SslContext ctx = helper.getContext((VertxInternal)vertx);
                builder.sslContext((SslContext)new DelegatingSslContext(ctx){

                    protected void initEngine(SSLEngine engine) {
                        helper.configureEngine(engine, null);
                    }
                });
            }
            Transport transport = ((VertxInternal)vertx).transport();
            this.id = id;
            this.options = options;
            this.server = ((NettyServerBuilder)builder.executor(command -> this.contextLocal.get().get(0).executeFromIO(event -> command.run()))).channelType(((ServerChannel)transport.serverChannelFactory(false).newChannel()).getClass()).bossEventLoopGroup((EventLoopGroup)this.group).workerEventLoopGroup((EventLoopGroup)this.group).build();
        }

        void start(ContextInternal context, Handler<AsyncResult<Void>> completionHandler) {
            boolean start = this.count.getAndIncrement() == 0;
            context.runOnContext(v -> {
                if (this.contextLocal.get() == null) {
                    this.contextLocal.set(new ArrayList());
                }
                this.manager.addHandler((Object)"foo", context);
                this.contextLocal.get().add(context);
                if (start) {
                    context.executeBlocking(v2 -> {
                        try {
                            this.server.start();
                            v2.complete();
                        }
                        catch (IOException e) {
                            v2.fail((Throwable)e);
                        }
                    }, completionHandler);
                } else {
                    completionHandler.handle((Object)Future.succeededFuture());
                }
            });
        }

        void stop(ContextInternal context, Handler<AsyncResult<Void>> completionHandler) {
            boolean shutdown = this.count.decrementAndGet() == 0;
            context.runOnContext(v -> {
                this.manager.removeHandler((Object)"foo", context);
                this.contextLocal.get().remove(context);
                if (shutdown) {
                    map.remove(this.id);
                    this.server.shutdown();
                }
                completionHandler.handle((Object)Future.succeededFuture());
            });
        }
    }
}

