/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcInvocation;
import io.vertx.grpc.server.impl.MountPoint;
import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.TranscodingServiceMethod;
import io.vertx.grpc.transcoding.impl.PathMatcher;
import io.vertx.grpc.transcoding.impl.PathMatcherBuilder;
import io.vertx.grpc.transcoding.impl.PathMatcherLookupResult;
import io.vertx.grpc.transcoding.impl.PathMatcherUtility;
import io.vertx.grpc.transcoding.impl.TranscodingGrpcServerRequest;
import io.vertx.grpc.transcoding.impl.TranscodingGrpcServerResponse;
import io.vertx.grpc.transcoding.impl.config.HttpTemplate;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TranscodingServiceMethodImpl<I, O>
implements TranscodingServiceMethod<I, O>,
MountPoint<I, O> {
    private final ServiceName serviceName;
    private final String methodName;
    private final GrpcMessageEncoder<O> encoder;
    private final GrpcMessageDecoder<I> decoder;
    private final MethodTranscodingOptions options;
    private final PathMatcher pathMatcher;

    public TranscodingServiceMethodImpl(ServiceName serviceName, String methodName, GrpcMessageEncoder<O> encoder, GrpcMessageDecoder<I> decoder) {
        this(serviceName, methodName, encoder, decoder, null);
    }

    public TranscodingServiceMethodImpl(ServiceName serviceName, String methodName, GrpcMessageEncoder<O> encoder, GrpcMessageDecoder<I> decoder, MethodTranscodingOptions options) {
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.encoder = encoder;
        this.decoder = decoder;
        this.options = options;
        if (options != null) {
            PathMatcherBuilder pmb = new PathMatcherBuilder();
            PathMatcherUtility.registerByHttpRule(pmb, options, this.fullMethodName());
            this.pathMatcher = pmb.build();
        } else {
            this.pathMatcher = null;
        }
    }

    public List<String> paths() {
        HashSet<String> paths = new HashSet<String>();
        this.computePaths(this.options, paths);
        return new ArrayList<String>(paths);
    }

    private void computePaths(MethodTranscodingOptions options, Set<String> paths) {
        String a;
        if (options == null || options.getPath().equals(this.fullMethodName())) {
            paths.add(this.fullMethodName());
            return;
        }
        HttpTemplate tmpl = HttpTemplate.parse(options.getPath());
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = tmpl.getSegments().iterator();
        while (!(!iterator.hasNext() || (a = iterator.next()).equals("*") || a.startsWith("{") && a.endsWith("}"))) {
            sb.append('/').append(a);
        }
        paths.add(sb.toString());
        List<MethodTranscodingOptions> extra = options.getAdditionalBindings();
        if (extra != null) {
            for (MethodTranscodingOptions o : extra) {
                this.computePaths(o, paths);
            }
        }
    }

    public GrpcInvocation<I, O> accept(HttpServerRequest httpRequest) {
        PathMatcherLookupResult res;
        if (!httpRequest.getHeader(HttpHeaders.CONTENT_TYPE).equals(GrpcProtocol.TRANSCODING.mediaType())) {
            return null;
        }
        PathMatcherLookupResult pathMatcherLookupResult = res = this.pathMatcher == null ? null : this.pathMatcher.lookup(httpRequest.method().name(), httpRequest.path(), httpRequest.query());
        if (res != null) {
            ArrayList<HttpVariableBinding> bindings = new ArrayList<HttpVariableBinding>(res.getVariableBindings());
            ContextInternal context = ((HttpServerRequestInternal)httpRequest).context();
            TranscodingGrpcServerRequest grpcRequest = new TranscodingGrpcServerRequest(context, httpRequest, this.options.getBody(), bindings, this.decoder, new GrpcMethodCall("/" + res.getMethod()));
            TranscodingGrpcServerResponse grpcResponse = new TranscodingGrpcServerResponse(context, grpcRequest, GrpcProtocol.TRANSCODING, httpRequest.response(), this.options.getResponseBody(), this.encoder);
            return new GrpcInvocation(grpcRequest, grpcResponse);
        }
        if (this.options == null) {
            ContextInternal context = ((HttpServerRequestInternal)httpRequest).context();
            TranscodingGrpcServerRequest grpcRequest = new TranscodingGrpcServerRequest(context, httpRequest, null, new ArrayList<HttpVariableBinding>(), this.decoder, new GrpcMethodCall("/" + this.methodName));
            TranscodingGrpcServerResponse grpcResponse = new TranscodingGrpcServerResponse(context, grpcRequest, GrpcProtocol.TRANSCODING, httpRequest.response(), null, this.encoder);
            return new GrpcInvocation(grpcRequest, grpcResponse);
        }
        return null;
    }

    public ServiceName serviceName() {
        return this.serviceName;
    }

    public String methodName() {
        return this.methodName;
    }

    public GrpcMessageDecoder<I> decoder() {
        return this.decoder;
    }

    public GrpcMessageEncoder<O> encoder() {
        return this.encoder;
    }

    @Override
    public MethodTranscodingOptions options() {
        return this.options;
    }
}

