/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathMatcherNode {
    public static final String HTTP_WILD_CARD = "*";
    private final Map<String, PathMatcherNode> children = new HashMap<String, PathMatcherNode>();
    private Map<String, PathMatcherNodeLookupResult> results = new HashMap<String, PathMatcherNodeLookupResult>();
    private boolean wildcard;

    public void lookupPath(List<String> path, int current, String method, PathMatcherNodeLookupResult result) {
        while (true) {
            if (current == path.size()) {
                PathMatcherNode child;
                if (!this.getResultForHttpMethod(method, result) && (child = this.children.get("**")) != null) {
                    child.getResultForHttpMethod(method, result);
                }
                return;
            }
            if (this.lookupPathFromChild(path.get(current), path, current, method, result)) {
                return;
            }
            if (!this.wildcard) break;
            ++current;
        }
        for (String childKey : new String[]{"/.", HTTP_WILD_CARD, "**"}) {
            if (!this.lookupPathFromChild(childKey, path, current, method, result)) continue;
            return;
        }
    }

    public boolean insertPath(PathInfo info, String method, Object data, boolean markDuplicates) {
        return this.insertTemplate(info.getPathInfo(), 0, method, data, markDuplicates);
    }

    private boolean insertTemplate(List<String> path, int current, String method, Object data, boolean markDuplicates) {
        if (current == path.size()) {
            PathMatcherNodeLookupResult existing = this.results.putIfAbsent(method, new PathMatcherNodeLookupResult(data, false));
            if (existing != null) {
                existing.data = data;
                if (markDuplicates) {
                    existing.multiple = true;
                }
                return false;
            }
            return true;
        }
        PathMatcherNode child = this.children.computeIfAbsent(path.get(current), k -> new PathMatcherNode());
        if (path.get(current).equals("**")) {
            child.setWildcard(true);
        }
        return child.insertTemplate(path, current + 1, method, data, markDuplicates);
    }

    private boolean lookupPathFromChild(String key, List<String> path, int current, String method, PathMatcherNodeLookupResult result) {
        PathMatcherNode child = this.children.get(key);
        if (child != null) {
            child.lookupPath(path, current + 1, method, result);
            if (result != null && result.data != null) {
                return true;
            }
        }
        return false;
    }

    private boolean getResultForHttpMethod(String key, PathMatcherNodeLookupResult result) {
        PathMatcherNodeLookupResult found = this.results.getOrDefault(key, this.results.get(HTTP_WILD_CARD));
        if (found != null) {
            result.data = found.data;
            result.multiple = found.multiple;
            return true;
        }
        return false;
    }

    private void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public PathMatcherNode clone() {
        PathMatcherNode clone = new PathMatcherNode();
        clone.results = new HashMap<String, PathMatcherNodeLookupResult>(this.results);
        for (Map.Entry<String, PathMatcherNode> entry : this.children.entrySet()) {
            clone.children.put(entry.getKey(), entry.getValue().clone());
        }
        clone.wildcard = this.wildcard;
        return clone;
    }

    public static class PathInfo {
        private final List<String> pathInfo;

        private PathInfo(Builder builder) {
            this.pathInfo = builder.path;
        }

        public List<String> getPathInfo() {
            return this.pathInfo;
        }

        public static class Builder {
            private final List<String> path = new ArrayList<String>();

            public Builder appendLiteralNode(String name) {
                if (name.equals("/.")) {
                    throw new IllegalArgumentException("Literal node cannot be a single parameter node");
                }
                this.path.add(name);
                return this;
            }

            public Builder appendSingleParameterNode() {
                this.path.add("/.");
                return this;
            }

            public PathInfo build() {
                return new PathInfo(this);
            }
        }
    }

    public static class PathMatcherNodeLookupResult {
        private Object data;
        private boolean multiple;

        public PathMatcherNodeLookupResult(Object data, boolean multiple) {
            this.data = data;
            this.multiple = multiple;
        }

        public Object getData() {
            return this.data;
        }

        public boolean isMultiple() {
            return this.multiple;
        }
    }
}

