/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import com.google.common.base.Splitter;
import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.impl.PathMatcherBuilder;
import io.vertx.grpc.transcoding.impl.PathMatcherNode;
import io.vertx.grpc.transcoding.impl.PercentEncoding;
import io.vertx.grpc.transcoding.impl.config.HttpTemplate;
import io.vertx.grpc.transcoding.impl.config.HttpTemplateVariable;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathMatcherUtility {
    public static boolean registerByHttpRule(PathMatcherBuilder pmb, MethodTranscodingOptions transcodingOptions, String method) {
        return PathMatcherUtility.registerByHttpRule(pmb, transcodingOptions, new HashSet<String>(), method);
    }

    public static boolean registerByHttpRule(PathMatcherBuilder pmb, MethodTranscodingOptions transcodingOptions, Set<String> systemQueryParameterNames, String method) {
        boolean ok = pmb.register(transcodingOptions, systemQueryParameterNames, method);
        if (transcodingOptions.getAdditionalBindings() == null) {
            return ok;
        }
        for (MethodTranscodingOptions binding : transcodingOptions.getAdditionalBindings()) {
            if (!ok) {
                return ok;
            }
            ok = PathMatcherUtility.registerByHttpRule(pmb, binding, systemQueryParameterNames, method);
        }
        return ok;
    }

    protected static List<HttpVariableBinding> extractBindingsFromPath(List<HttpTemplateVariable> vars, List<String> parts, PercentEncoding.UrlUnescapeSpec unescapeSpec) {
        if (vars == null || vars.isEmpty()) {
            return List.of();
        }
        ArrayList<HttpVariableBinding> bindings = new ArrayList<HttpVariableBinding>();
        for (HttpTemplateVariable var : vars) {
            HttpVariableBinding binding = new HttpVariableBinding(var.getFieldPath(), null);
            int end = var.getEndSegment() >= 0 ? var.getEndSegment() : parts.size() + var.getEndSegment() + 1;
            boolean multipart = end - var.getStartSegment() > 1 || var.getEndSegment() < 0;
            PercentEncoding.UrlUnescapeSpec spec = multipart ? unescapeSpec : PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS;
            for (int i = var.getStartSegment(); i < end; ++i) {
                String currentValue = binding.getValue();
                currentValue = currentValue == null ? "" : currentValue;
                binding.setValue(currentValue + PercentEncoding.urlUnescapeString(parts.get(i), spec, false));
                if (i >= end - 1) continue;
                binding.setValue(binding.getValue() + "/");
            }
            bindings.add(binding);
        }
        return bindings;
    }

    protected static List<HttpVariableBinding> extractBindingsFromQueryParameters(String queryParams, Set<String> systemParams, boolean queryParamUnescapePlus) {
        if (queryParams == null) {
            return List.of();
        }
        ArrayList<HttpVariableBinding> bindings = new ArrayList<HttpVariableBinding>();
        List params = Splitter.on((char)'&').splitToList((CharSequence)queryParams);
        for (String param : params) {
            String name;
            int pos = param.indexOf(61);
            if (pos == 0 || pos == -1 || systemParams.contains(name = param.substring(0, pos))) continue;
            HttpVariableBinding binding = new HttpVariableBinding(Splitter.on((char)'.').splitToList((CharSequence)name), PercentEncoding.urlUnescapeString(param.substring(pos + 1), PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS, queryParamUnescapePlus));
            bindings.add(binding);
        }
        return bindings;
    }

    protected static List<String> extractRequestParts(String path, Set<String> customVerbs, boolean matchUnregisteredCustomVerb) {
        if (path.indexOf(63) != -1) {
            path = path.substring(0, path.indexOf(63));
        }
        int lastIndexOfColon = path.lastIndexOf(58);
        int lastIndexOfSlash = path.lastIndexOf(47);
        if (lastIndexOfColon != -1 && lastIndexOfColon > lastIndexOfSlash) {
            String verb = path.substring(lastIndexOfColon + 1);
            if (matchUnregisteredCustomVerb || customVerbs.contains(verb)) {
                path = path.substring(0, lastIndexOfColon);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!path.isEmpty()) {
            result = new ArrayList(Splitter.on((char)'/').splitToList((CharSequence)path.substring(1)));
        }
        while (!result.isEmpty() && ((String)result.get(result.size() - 1)).isEmpty()) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    protected static String extractVerb(String path, Set<String> customVerbs, boolean matchUnregisteredCustomVerb) {
        if (path.indexOf(63) != -1) {
            path = path.substring(0, path.indexOf(63));
        }
        int lastIndexOfColon = path.lastIndexOf(58);
        int lastIndexOfSlash = path.lastIndexOf(47);
        if (lastIndexOfColon != -1 && lastIndexOfColon > lastIndexOfSlash) {
            String verb = path.substring(lastIndexOfColon + 1);
            if (matchUnregisteredCustomVerb || customVerbs.contains(verb)) {
                return verb;
            }
        }
        return "";
    }

    protected static PathMatcherNode.PathMatcherNodeLookupResult lookupInPathMatcherNode(PathMatcherNode root, List<String> parts, String httpMethod) {
        PathMatcherNode.PathMatcherNodeLookupResult result = new PathMatcherNode.PathMatcherNodeLookupResult(null, false);
        root.lookupPath(parts, 0, httpMethod, result);
        return result;
    }

    protected static PathMatcherNode.PathInfo transformHttpTemplate(HttpTemplate template) {
        PathMatcherNode.PathInfo.Builder builder = new PathMatcherNode.PathInfo.Builder();
        for (String part : template.getSegments()) {
            builder.appendLiteralNode(part);
        }
        return builder.build();
    }
}

