/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server;

import com.google.protobuf.Descriptors;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.ServiceBuilder;
import io.vertx.grpc.server.impl.ServiceBuilderImpl;
import java.util.List;
import java.util.Optional;

@GenIgnore(value={"permitted-type"})
public interface Service {
    public static ServiceBuilder service(ServiceName serviceName, Descriptors.ServiceDescriptor descriptor) {
        return new ServiceBuilderImpl(serviceName, descriptor);
    }

    public ServiceName name();

    public Descriptors.ServiceDescriptor descriptor();

    public void bind(GrpcServer var1);

    default public List<Descriptors.MethodDescriptor> methodDescriptors() {
        return this.descriptor().getMethods();
    }

    default public Optional<Descriptors.MethodDescriptor> methodDescriptor(String methodName) {
        return this.methodDescriptors().stream().filter(method -> method.getName().equals(methodName)).findFirst();
    }

    default public boolean hasMethod(String methodName) {
        return this.methodDescriptor(methodName).isPresent();
    }

    default public String pathOfMethod(String methodName) {
        if (!this.hasMethod(methodName)) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        return this.name().pathOf(methodName);
    }
}

