/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcHeaderNames;
import io.vertx.grpc.common.GrpcMediaType;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.common.impl.Http2GrpcMessageDeframer;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;

public class WebGrpcServerRequest<Req, Resp>
extends GrpcServerRequestImpl<Req, Resp> {
    public WebGrpcServerRequest(ContextInternal context, GrpcProtocol protocol, WireFormat format, long maxMessageSize, HttpServerRequest httpRequest, GrpcMessageDecoder<Req> messageDecoder, GrpcMethodCall methodCall) {
        super(context, protocol, format, httpRequest, httpRequest.version() != HttpVersion.HTTP_2 && GrpcMediaType.isGrpcWebText((CharSequence)httpRequest.getHeader(HttpHeaders.CONTENT_TYPE)) ? new TextMessageDeframer() : new Http2GrpcMessageDeframer(httpRequest.headers().get((CharSequence)GrpcHeaderNames.GRPC_ENCODING), format), messageDecoder, methodCall);
    }

    static class TextMessageDeframer
    implements GrpcMessageDeframer {
        private long maxMessageSize;
        private boolean processed;
        private Buffer buffer;
        private Object result;

        TextMessageDeframer() {
        }

        public void maxMessageSize(long maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public void update(Buffer chunk) {
            if (this.processed) {
                return;
            }
            if (this.buffer == null) {
                this.buffer = chunk;
            } else {
                try {
                    this.buffer.appendBuffer(chunk);
                }
                catch (IndexOutOfBoundsException e) {
                    this.buffer = this.buffer.copy();
                    this.buffer.appendBuffer(chunk);
                }
            }
            if (this.result == null && (long)this.buffer.length() > this.maxMessageSize) {
                this.result = new MessageSizeOverflowException((long)this.buffer.length());
                this.buffer = null;
                this.processed = true;
            }
        }

        public void end() {
            if (!this.processed) {
                BufferInternal decoded = BufferInternal.buffer((ByteBuf)Base64.decode((ByteBuf)((BufferInternal)this.buffer).getByteBuf()));
                this.buffer = null;
                this.result = GrpcMessage.message((String)"identity", (Buffer)decoded.slice(5, decoded.length()));
            }
        }

        public Object next() {
            if (this.result != null) {
                Object ret = this.result;
                this.result = null;
                return ret;
            }
            return null;
        }
    }
}

