/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.GrpcMessageImpl;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import java.util.Map;
import java.util.Objects;

public abstract class GrpcServerResponseImpl<Req, Resp>
extends GrpcWriteStreamBase<GrpcServerResponseImpl<Req, Resp>, Resp>
implements GrpcServerResponse<Req, Resp> {
    private final GrpcServerRequestImpl<Req, Resp> request;
    private final HttpServerResponse httpResponse;
    private final GrpcProtocol protocol;
    private GrpcStatus status = GrpcStatus.OK;
    private String statusMessage;
    private boolean trailersOnly;
    private boolean cancelled;

    public GrpcServerResponseImpl(ContextInternal context, GrpcServerRequestImpl<Req, Resp> request, GrpcProtocol protocol, HttpServerResponse httpResponse, GrpcMessageEncoder<Resp> encoder) {
        super(context, protocol.mediaType(), (WriteStream)httpResponse, encoder);
        this.request = request;
        this.httpResponse = httpResponse;
        this.protocol = protocol;
    }

    @Override
    public GrpcServerResponse<Req, Resp> status(GrpcStatus status) {
        Objects.requireNonNull(status);
        this.status = status;
        return this;
    }

    @Override
    public GrpcServerResponse<Req, Resp> statusMessage(String msg) {
        this.statusMessage = msg;
        return this;
    }

    public void handleTimeout() {
        if (!this.isCancelled()) {
            if (!this.isTrailersSent()) {
                this.status(GrpcStatus.DEADLINE_EXCEEDED);
                this.end();
            } else {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        Future fut = this.request.end();
        if (fut.failed()) {
            return;
        }
        boolean requestEnded = fut.succeeded();
        if (!requestEnded || !this.isTrailersSent()) {
            this.sendCancel();
        }
    }

    public boolean isTrailersOnly() {
        return this.trailersOnly;
    }

    public GrpcStatus status() {
        return this.status;
    }

    protected void sendCancel() {
        this.httpResponse.reset(GrpcError.CANCELLED.http2ResetCode).onSuccess(v -> this.handleError(GrpcError.CANCELLED));
    }

    protected void setHeaders(String contentType, MultiMap grpcHeaders, boolean isEnd) {
        this.trailersOnly = this.status != GrpcStatus.OK && isEnd;
        MultiMap httpHeaders = this.httpResponse.headers();
        httpHeaders.set("content-type", contentType);
        this.encodeGrpcHeaders(grpcHeaders, httpHeaders);
    }

    protected void encodeGrpcHeaders(MultiMap grpcHeaders, MultiMap httpHeaders) {
        if (grpcHeaders != null && !grpcHeaders.isEmpty()) {
            for (Map.Entry header : grpcHeaders) {
                httpHeaders.add((String)header.getKey(), (String)header.getValue());
            }
        }
    }

    protected void setTrailers(MultiMap grpcTrailers) {
    }

    protected void encodeGrpcTrailers(MultiMap grpcTrailers, MultiMap httpTrailers) {
        MultiMap httpHeaders = this.httpResponse.headers();
        if (grpcTrailers != null && !grpcTrailers.isEmpty()) {
            for (Map.Entry trailer : grpcTrailers) {
                httpTrailers.add((String)trailer.getKey(), (String)trailer.getValue());
            }
        }
        if (!httpHeaders.contains("grpc-status")) {
            httpTrailers.set("grpc-status", this.status.toString());
        }
        if (this.status != GrpcStatus.OK) {
            String msg = this.statusMessage;
            if (msg != null && !httpHeaders.contains("grpc-message")) {
                httpTrailers.set("grpc-message", Utils.utf8PercentEncode((String)msg));
            }
        } else {
            httpTrailers.remove("grpc-message");
        }
    }

    protected Future<Void> sendMessage(Buffer message, boolean compressed) {
        return this.httpResponse.write((Object)this.encodeMessage(message, compressed, false));
    }

    protected Future<Void> sendEnd() {
        this.request.cancelTimeout();
        return this.httpResponse.end();
    }

    protected Buffer encodeMessage(Buffer message, boolean compressed, boolean trailer) {
        return GrpcMessageImpl.encode((Buffer)message, (boolean)compressed, (boolean)trailer);
    }
}

