/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Timer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMediaType;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrpcServerRequestImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcServerRequestImpl<Req, Resp>, Req>
implements GrpcServerRequest<Req, Resp> {
    private static final Pattern TIMEOUT_PATTERN = Pattern.compile("([0-9]{1,8})([HMSmun])");
    private static final Map<String, TimeUnit> TIMEOUT_MAPPING;
    private static final BufferInternal EMPTY_BUFFER;
    final HttpServerRequest httpRequest;
    final GrpcServerResponseImpl<Req, Resp> response;
    final long timeout;
    final boolean scheduleDeadline;
    final GrpcProtocol protocol;
    private final GrpcMethodCall methodCall;
    private BufferInternal grpcWebTextBuffer;
    private Timer deadline;

    private static long parseTimeout(String timeout) {
        Matcher matcher = TIMEOUT_PATTERN.matcher(timeout);
        if (matcher.matches()) {
            long value = Long.parseLong(matcher.group(1));
            TimeUnit unit = TIMEOUT_MAPPING.get(matcher.group(2));
            return unit.toMillis(value);
        }
        return 0L;
    }

    public GrpcServerRequestImpl(ContextInternal context, boolean scheduleDeadline, GrpcProtocol protocol, WireFormat format, long maxMessageSize, HttpServerRequest httpRequest, GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, GrpcMethodCall methodCall) {
        super((Context)context, (ReadStream)httpRequest, httpRequest.headers().get("grpc-encoding"), format, maxMessageSize, messageDecoder);
        String timeoutHeader = httpRequest.getHeader("grpc-timeout");
        long timeout = timeoutHeader != null ? GrpcServerRequestImpl.parseTimeout(timeoutHeader) : 0L;
        GrpcServerResponseImpl response = new GrpcServerResponseImpl(context, this, protocol, httpRequest.response(), messageEncoder);
        response.init();
        this.protocol = protocol;
        this.timeout = timeout;
        this.httpRequest = httpRequest;
        this.response = response;
        this.methodCall = methodCall;
        this.scheduleDeadline = scheduleDeadline;
        this.grpcWebTextBuffer = httpRequest.version() != HttpVersion.HTTP_2 && GrpcMediaType.isGrpcWebText((CharSequence)httpRequest.getHeader(HttpHeaders.CONTENT_TYPE)) ? EMPTY_BUFFER : null;
    }

    public void init(GrpcWriteStreamBase ws) {
        super.init(ws);
        if (this.timeout > 0L && this.scheduleDeadline) {
            Timer timer;
            this.deadline = timer = this.context.timer(this.timeout, TimeUnit.MILLISECONDS);
            timer.onSuccess(v -> this.response.handleTimeout());
        }
    }

    void cancelTimeout() {
        Timer timer = this.deadline;
        if (timer != null) {
            this.deadline = null;
            timer.cancel();
        }
    }

    @Override
    public String fullMethodName() {
        return this.methodCall.fullMethodName();
    }

    public MultiMap headers() {
        return this.httpRequest.headers();
    }

    @Override
    public ServiceName serviceName() {
        return this.methodCall.serviceName();
    }

    @Override
    public String methodName() {
        return this.methodCall.methodName();
    }

    @Override
    public GrpcServerRequestImpl<Req, Resp> handler(Handler<Req> handler) {
        if (handler != null) {
            return (GrpcServerRequestImpl)this.messageHandler(msg -> {
                Object decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    this.response.cancel();
                    return;
                }
                handler.handle(decoded);
            });
        }
        return (GrpcServerRequestImpl)this.messageHandler(null);
    }

    @Override
    public GrpcServerResponse<Req, Resp> response() {
        return this.response;
    }

    @Override
    public HttpConnection connection() {
        return this.httpRequest.connection();
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public Timer deadline() {
        return this.deadline;
    }

    public void handle(Buffer chunk) {
        if (this.notGrpcWebText()) {
            super.handle(chunk);
            return;
        }
        if (this.grpcWebTextBuffer == EMPTY_BUFFER) {
            ByteBuf bbuf = ((BufferInternal)chunk).getByteBuf();
            if ((chunk.length() & 3) == 0) {
                super.handle((Buffer)BufferInternal.buffer((ByteBuf)Base64.decode((ByteBuf)bbuf)));
            } else {
                this.grpcWebTextBuffer = BufferInternal.buffer((ByteBuf)bbuf.copy());
            }
            return;
        }
        this.bufferAndDecode(chunk);
    }

    private boolean notGrpcWebText() {
        return this.grpcWebTextBuffer == null;
    }

    private void bufferAndDecode(Buffer chunk) {
        this.grpcWebTextBuffer.appendBuffer(chunk);
        int len = this.grpcWebTextBuffer.length();
        int maxDecodable = len & 0xFFFFFFFC;
        if (maxDecodable == len) {
            BufferInternal decoded = BufferInternal.buffer((ByteBuf)Base64.decode((ByteBuf)this.grpcWebTextBuffer.getByteBuf()));
            this.grpcWebTextBuffer = EMPTY_BUFFER;
            super.handle((Buffer)decoded);
        } else if (maxDecodable > 0) {
            ByteBuf bbuf = this.grpcWebTextBuffer.getByteBuf();
            BufferInternal decoded = BufferInternal.buffer((ByteBuf)Base64.decode((ByteBuf)bbuf, (int)0, (int)maxDecodable));
            this.grpcWebTextBuffer = BufferInternal.buffer((ByteBuf)bbuf.copy(maxDecodable, len - maxDecodable));
            super.handle((Buffer)decoded);
        }
    }

    static {
        HashMap<String, TimeUnit> timeoutMapping = new HashMap<String, TimeUnit>();
        timeoutMapping.put("H", TimeUnit.HOURS);
        timeoutMapping.put("M", TimeUnit.MINUTES);
        timeoutMapping.put("S", TimeUnit.SECONDS);
        timeoutMapping.put("m", TimeUnit.MILLISECONDS);
        timeoutMapping.put("u", TimeUnit.MICROSECONDS);
        timeoutMapping.put("n", TimeUnit.NANOSECONDS);
        TIMEOUT_MAPPING = timeoutMapping;
        EMPTY_BUFFER = BufferInternal.buffer((ByteBuf)Unpooled.EMPTY_BUFFER);
    }
}

