/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.type.AnnotationValueInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumValueInfo {
    private final String identifier;
    private final Doc doc;
    private final boolean deprecated;
    private final Text deprecatedDesc;
    private final Map<String, AnnotationValueInfo> annotations;

    public EnumValueInfo(String identifier, Doc doc, boolean deprecated, Text deprecatedDesc, List<AnnotationValueInfo> annotations) {
        this.identifier = identifier;
        this.doc = doc;
        this.deprecated = deprecated;
        this.deprecatedDesc = deprecatedDesc;
        this.annotations = annotations.stream().collect(HashMap::new, (m3, a) -> m3.put(a.getName(), a), HashMap::putAll);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Text getDeprecatedDesc() {
        return this.deprecatedDesc;
    }

    public List<AnnotationValueInfo> getAnnotations() {
        return new ArrayList<AnnotationValueInfo>(this.annotations.values());
    }

    public AnnotationValueInfo getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }
}

