/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.processor.EnumValueInfo;
import io.vertx.codegen.processor.GenException;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.Model;
import io.vertx.codegen.processor.ModuleInfo;
import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Tag;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.doc.Token;
import io.vertx.codegen.processor.type.AnnotationValueInfo;
import io.vertx.codegen.processor.type.AnnotationValueInfoFactory;
import io.vertx.codegen.processor.type.EnumTypeInfo;
import io.vertx.codegen.processor.type.TypeMirrorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class EnumModel
implements Model {
    private final Doc.Factory docFactory;
    protected final Elements elementUtils;
    protected final Types typeUtils;
    protected final TypeElement modelElt;
    protected final TypeMirrorFactory typeMirrorFactory;
    protected EnumTypeInfo type;
    private final AnnotationValueInfoFactory annotationValueInfoFactory;
    private Doc doc;
    private List<EnumValueInfo> values;
    private List<AnnotationValueInfo> annotations;
    private boolean processed;
    private boolean deprecated;
    private Text deprecatedDesc;

    public EnumModel(ProcessingEnvironment env, TypeElement modelElt) {
        this.typeUtils = env.getTypeUtils();
        this.elementUtils = env.getElementUtils();
        this.typeMirrorFactory = new TypeMirrorFactory(this.elementUtils, this.typeUtils);
        this.docFactory = new Doc.Factory(env.getMessager(), this.elementUtils, this.typeUtils, this.typeMirrorFactory, modelElt);
        this.modelElt = modelElt;
        this.annotationValueInfoFactory = new AnnotationValueInfoFactory(this.typeMirrorFactory);
        this.deprecated = modelElt.getAnnotation(Deprecated.class) != null;
    }

    @Override
    public boolean process() {
        if (!this.processed) {
            if (this.modelElt.getKind() != ElementKind.ENUM) {
                throw new GenException(this.modelElt, "@VertxGen can only be used with interfaces or enums" + this.modelElt.asType().toString());
            }
            this.processTypeAnnotations();
            this.doc = this.docFactory.createDoc(this.modelElt);
            if (this.doc != null) {
                this.doc.getBlockTags().stream().filter(tag -> tag.getName().equals("deprecated")).findFirst().ifPresent(tag -> {
                    this.deprecatedDesc = new Text(Helper.normalizeWhitespaces(tag.getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
                });
            }
            this.type = (EnumTypeInfo)this.typeMirrorFactory.create(this.modelElt.asType());
            Helper.checkUnderModule(this, "@VertxGen");
            this.values = this.elementUtils.getAllMembers(this.modelElt).stream().filter(elt -> elt.getKind() == ElementKind.ENUM_CONSTANT).flatMap(Helper.cast(VariableElement.class)).map(elt -> {
                Optional<Tag> methodDeprecatedTag;
                Doc doc = this.docFactory.createDoc((Element)elt);
                Text enumItemDeprecatedDesc = null;
                if (doc != null && (methodDeprecatedTag = doc.getBlockTags().stream().filter(tag -> tag.getName().equals("deprecated")).findFirst()).isPresent()) {
                    enumItemDeprecatedDesc = new Text(Helper.normalizeWhitespaces(methodDeprecatedTag.get().getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
                }
                List<? extends AnnotationMirror> annotationMirrors = elt.getAnnotationMirrors();
                ArrayList<AnnotationValueInfo> annotationValueInfos = new ArrayList<AnnotationValueInfo>();
                if (annotationMirrors != null) {
                    annotationMirrors.stream().map(this.annotationValueInfoFactory::processAnnotation).forEach(annotationValueInfos::add);
                }
                return new EnumValueInfo(elt.getSimpleName().toString(), doc, elt.getAnnotation(Deprecated.class) != null, enumItemDeprecatedDesc, annotationValueInfos);
            }).collect(Collectors.toList());
            if (this.values.isEmpty()) {
                throw new GenException(this.modelElt, "No empty enums");
            }
            this.processed = true;
            return true;
        }
        return false;
    }

    private void processTypeAnnotations() {
        this.annotations = this.elementUtils.getAllAnnotationMirrors(this.modelElt).stream().map(this.annotationValueInfoFactory::processAnnotation).collect(Collectors.toList());
    }

    @Override
    public List<AnnotationValueInfo> getAnnotations() {
        return this.annotations;
    }

    public EnumTypeInfo getType() {
        return this.type;
    }

    public List<EnumValueInfo> getValues() {
        return this.values;
    }

    public Doc getDoc() {
        return this.doc;
    }

    @Override
    public String getKind() {
        return "enum";
    }

    @Override
    public Element getElement() {
        return this.modelElt;
    }

    @Override
    public String getFqn() {
        return this.modelElt.getQualifiedName().toString();
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Text getDeprecatedDesc() {
        return this.deprecatedDesc;
    }

    @Override
    public Map<String, Object> getVars() {
        Map<String, Object> vars = Model.super.getVars();
        vars.put("type", this.getType());
        vars.put("doc", this.doc);
        vars.put("values", this.values);
        vars.put("deprecated", this.deprecated);
        vars.put("deprecatedDesc", this.getDeprecatedDesc());
        return vars;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getModule();
    }
}

