/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import java.util.Objects;

public class ParamInfo {
    final int index;
    final String name;
    final Text description;
    final TypeInfo type;
    final TypeInfo unresolvedType;

    public ParamInfo(int index, String name, Text description, TypeInfo type) {
        this(index, name, description, type, null);
    }

    public ParamInfo(int index, String name, Text description, TypeInfo type, TypeInfo unresolvedType) {
        this.index = index;
        this.name = name;
        this.description = description;
        this.type = type;
        this.unresolvedType = unresolvedType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(CamelCase.INSTANCE.parse(this.name));
    }

    public Text getDescription() {
        return this.description;
    }

    public boolean isNullable() {
        return this.type.getKind() == ClassKind.OBJECT || this.type.isNullable();
    }

    public Boolean isNullableCallback() {
        if (Objects.requireNonNull(this.type.getKind()) == ClassKind.HANDLER) {
            TypeInfo handler = ((ParameterizedTypeInfo)this.type).getArg(0);
            return handler.isNullable();
        }
        return null;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public TypeInfo getUnresolvedType() {
        return this.unresolvedType;
    }

    public boolean isDataObject() {
        return this.type.isDataObjectHolder();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParamInfo)) {
            return false;
        }
        ParamInfo pother = (ParamInfo)other;
        return this.name.equals(pother.name) && this.type.equals(pother.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

