/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;

public class Http2GrpcMessageDeframer
implements GrpcMessageDeframer {
    private final long maxMessageSize;
    private final String encoding;
    private final WireFormat format;
    private Buffer buffer;
    private long bytesToSkip;

    public Http2GrpcMessageDeframer(long maxMessageSize, String encoding, WireFormat format) {
        this.maxMessageSize = maxMessageSize;
        this.encoding = encoding;
        this.format = format;
    }

    @Override
    public void update(Buffer chunk) {
        if (this.bytesToSkip > 0L) {
            int len = chunk.length();
            if ((long)len <= this.bytesToSkip) {
                this.bytesToSkip -= (long)len;
                return;
            }
            chunk = chunk.slice((int)this.bytesToSkip, len);
            this.bytesToSkip = 0L;
        }
        if (this.buffer == null) {
            this.buffer = chunk;
        } else {
            try {
                this.buffer.appendBuffer(chunk);
            }
            catch (IndexOutOfBoundsException e) {
                this.buffer = this.buffer.copy();
                this.buffer.appendBuffer(chunk);
            }
        }
    }

    @Override
    public void end() {
    }

    @Override
    public Object next() {
        boolean compressed;
        if (this.buffer == null) {
            return null;
        }
        int idx = 0;
        if (idx + 5 > this.buffer.length()) {
            return null;
        }
        long len = (long)this.buffer.getInt(idx + 1) & 0xFFFFFFFFL;
        if (len > this.maxMessageSize) {
            MessageSizeOverflowException msoe = new MessageSizeOverflowException(len);
            if ((long)this.buffer.length() < len + 5L) {
                this.bytesToSkip = len + 5L - (long)this.buffer.length();
                this.buffer = null;
            } else {
                this.buffer = this.buffer.slice((int)(len + 5L), this.buffer.length());
            }
            return msoe;
        }
        if (len > (long)(this.buffer.length() - (idx + 5))) {
            return null;
        }
        boolean bl = compressed = this.buffer.getByte(idx) == 1;
        if (compressed && this.encoding == null) {
            throw new UnsupportedOperationException("Handle me");
        }
        Buffer payload = this.buffer.slice(idx + 5, (int)((long)(idx + 5) + len));
        GrpcMessage message = GrpcMessage.message(compressed ? this.encoding : "identity", this.format, payload);
        if ((idx += 5 + (int)len) < this.buffer.length()) {
            if (idx > 0) {
                this.buffer = this.buffer.getBuffer(idx, this.buffer.length());
            }
        } else {
            this.buffer = null;
        }
        return message;
    }
}

