/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcReadStream;
import io.vertx.grpc.common.InvalidMessageException;
import io.vertx.grpc.common.InvalidMessagePayloadException;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import io.vertx.grpc.common.impl.Utils;

public abstract class GrpcReadStreamBase<S extends GrpcReadStreamBase<S, T>, T>
implements GrpcReadStream<T>,
Handler<Buffer> {
    static final GrpcMessage END_SENTINEL = new GrpcMessage(){

        @Override
        public String encoding() {
            return null;
        }

        @Override
        public WireFormat format() {
            return null;
        }

        @Override
        public Buffer payload() {
            return null;
        }
    };
    protected final ContextInternal context;
    private final String encoding;
    private final WireFormat format;
    private final ReadStream<Buffer> stream;
    private final GrpcMessageDeframer deframer;
    private final InboundMessageQueue<GrpcMessage> queue;
    private Handler<Throwable> exceptionHandler;
    private Handler<GrpcMessage> messageHandler;
    private Handler<Void> endHandler;
    private Handler<InvalidMessageException> invalidMessageHandler;
    private GrpcMessage last;
    private final GrpcMessageDecoder<T> messageDecoder;
    private final Promise<Void> end;
    private GrpcWriteStreamBase<?, ?> ws;

    protected GrpcReadStreamBase(Context context, final ReadStream<Buffer> stream, String encoding, WireFormat format, GrpcMessageDeframer messageDeframer, GrpcMessageDecoder<T> messageDecoder) {
        ContextInternal ctx;
        this.context = ctx = (ContextInternal)context;
        this.encoding = encoding;
        this.stream = stream;
        this.format = format;
        this.queue = new InboundMessageQueue<GrpcMessage>(ctx.executor(), ctx.executor(), 8, 16){

            protected void handleResume() {
                stream.resume();
            }

            protected void handlePause() {
                stream.pause();
            }

            protected void handleMessage(GrpcMessage msg) {
                if (msg == END_SENTINEL) {
                    GrpcReadStreamBase.this.handleEnd();
                } else {
                    GrpcReadStreamBase.this.handleMessage(msg);
                }
            }
        };
        this.messageDecoder = messageDecoder;
        this.end = ctx.promise();
        this.deframer = messageDeframer;
    }

    public void init(GrpcWriteStreamBase<?, ?> ws) {
        this.ws = ws;
        this.stream.handler((Handler)this);
        this.stream.endHandler(v -> {
            this.deframer.end();
            this.deframe();
            this.queue.write((Object)END_SENTINEL);
        });
        this.stream.exceptionHandler(err -> {
            if (err instanceof StreamResetException) {
                StreamResetException reset = (StreamResetException)err;
                GrpcError error = GrpcError.mapHttp2ErrorCode(reset.getCode());
                ws.handleError(error);
            } else {
                this.handleException((Throwable)err);
            }
        });
    }

    protected final T decodeMessage(GrpcMessage msg) throws CodecException {
        switch (msg.encoding()) {
            case "identity": {
                break;
            }
            case "gzip": {
                msg = GrpcMessage.message("identity", msg.format(), Utils.GZIP_DECODER.apply(msg.payload()));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.messageDecoder.decode(msg);
    }

    @Override
    public final WireFormat format() {
        return this.format;
    }

    @Override
    public final String encoding() {
        return this.encoding;
    }

    public final S pause() {
        this.queue.pause();
        return (S)this;
    }

    public final S resume() {
        return (S)this.fetch(Long.MAX_VALUE);
    }

    public final S fetch(long amount) {
        this.queue.fetch(amount);
        return (S)this;
    }

    public final S exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (S)this;
    }

    public final S errorHandler(@Nullable Handler<GrpcError> handler) {
        this.ws.errorHandler(handler);
        return (S)this;
    }

    public final S messageHandler(Handler<GrpcMessage> handler) {
        this.messageHandler = handler;
        return (S)this;
    }

    public final S invalidMessageHandler(@Nullable Handler<InvalidMessageException> handler) {
        this.invalidMessageHandler = handler;
        return (S)this;
    }

    public S handler(@Nullable Handler<T> handler) {
        if (handler != null) {
            return (S)this.messageHandler(msg -> {
                T decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    Handler<InvalidMessageException> errorHandler = this.invalidMessageHandler;
                    if (errorHandler != null) {
                        InvalidMessagePayloadException impe = new InvalidMessagePayloadException((GrpcMessage)msg, e);
                        errorHandler.handle((Object)impe);
                    }
                    return;
                }
                handler.handle(decoded);
            });
        }
        return (S)this.messageHandler((Handler)null);
    }

    public final S endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return (S)this;
    }

    public void handle(Buffer chunk) {
        this.deframer.update(chunk);
        this.deframe();
    }

    private void deframe() {
        Object ret;
        while ((ret = this.deframer.next()) != null) {
            if (ret instanceof MessageSizeOverflowException) {
                MessageSizeOverflowException msoe = (MessageSizeOverflowException)((Object)ret);
                Handler<InvalidMessageException> handler = this.invalidMessageHandler;
                if (handler == null) continue;
                this.context.dispatch((Object)msoe, handler);
                continue;
            }
            GrpcMessage msg = (GrpcMessage)ret;
            this.queue.write((Object)msg);
        }
    }

    public final void tryFail(Throwable err) {
        Handler<Throwable> handler;
        if (this.end.tryFail(err) && (handler = this.exceptionHandler) != null) {
            this.context.dispatch((Object)err, handler);
        }
    }

    protected final void handleException(Throwable err) {
        this.tryFail(err);
    }

    protected void handleEnd() {
        this.end.tryComplete();
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            this.context.dispatch(handler);
        }
    }

    private void handleMessage(GrpcMessage msg) {
        this.last = msg;
        Handler<GrpcMessage> handler = this.messageHandler;
        if (handler != null) {
            this.context.dispatch((Object)msg, this.messageHandler);
        }
    }

    @Override
    public final Future<T> last() {
        return this.end().map(v -> this.decodeMessage(this.last));
    }

    @Override
    public Future<Void> end() {
        return this.end.future();
    }
}

