/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;

public interface GrpcMessageEncoder<T> {
    public static final GrpcMessageEncoder<Buffer> IDENTITY = new GrpcMessageEncoder<Buffer>(){

        @Override
        public GrpcMessage encode(Buffer msg, WireFormat format) throws CodecException {
            return GrpcMessage.message("identity", format, msg);
        }

        @Override
        public boolean accepts(WireFormat format) {
            return true;
        }
    };
    public static final GrpcMessageEncoder<JsonObject> JSON_OBJECT = new GrpcMessageEncoder<JsonObject>(){

        @Override
        public GrpcMessage encode(JsonObject msg, WireFormat format) throws CodecException {
            return GrpcMessage.message("identity", WireFormat.JSON, msg == null ? Buffer.buffer((String)"null") : msg.toBuffer());
        }

        @Override
        public boolean accepts(WireFormat format) {
            return format == WireFormat.JSON;
        }
    };

    @GenIgnore
    public static <T extends MessageLite> GrpcMessageEncoder<T> encoder() {
        return new GrpcMessageEncoder<T>(){

            @Override
            public GrpcMessage encode(T msg, WireFormat format) throws CodecException {
                switch (format) {
                    case PROTOBUF: {
                        byte[] bytes = msg.toByteArray();
                        return GrpcMessage.message("identity", Buffer.buffer((byte[])bytes));
                    }
                    case JSON: {
                        if (msg instanceof MessageOrBuilder) {
                            MessageOrBuilder mob = (MessageOrBuilder)msg;
                            try {
                                String res = JsonFormat.printer().print(mob);
                                return GrpcMessage.message("identity", WireFormat.JSON, Buffer.buffer((String)res));
                            }
                            catch (InvalidProtocolBufferException e) {
                                throw new CodecException(e);
                            }
                        }
                        return GrpcMessage.message("identity", WireFormat.JSON, Json.encodeToBuffer(msg));
                    }
                }
                throw new IllegalArgumentException("Invalid wire format: " + format);
            }

            @Override
            public boolean accepts(WireFormat format) {
                return true;
            }
        };
    }

    public static <T> GrpcMessageEncoder<T> json() {
        return new GrpcMessageEncoder<T>(){

            @Override
            public GrpcMessage encode(T msg, WireFormat format) throws CodecException {
                if (msg instanceof MessageOrBuilder) {
                    MessageOrBuilder mob = (MessageOrBuilder)msg;
                    try {
                        String res = JsonFormat.printer().print(mob);
                        return GrpcMessage.message("identity", WireFormat.JSON, Buffer.buffer((String)res));
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new CodecException(e);
                    }
                }
                return GrpcMessage.message("identity", WireFormat.JSON, Json.encodeToBuffer(msg));
            }

            @Override
            public boolean accepts(WireFormat format) {
                return format == WireFormat.JSON;
            }
        };
    }

    public GrpcMessage encode(T var1, WireFormat var2) throws CodecException;

    public boolean accepts(WireFormat var1);
}

