/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.vertx.core.VertxException;
import io.vertx.core.http.StreamResetException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcStatus;

public final class GrpcErrorException
extends VertxException {
    private final GrpcError error;
    private final GrpcStatus status;

    public static GrpcErrorException create(StreamResetException sre) {
        GrpcError error = GrpcError.mapHttp2ErrorCode(sre.getCode());
        GrpcStatus status = GrpcStatus.UNKNOWN;
        if (error != null) {
            status = error.status;
        }
        return new GrpcErrorException(error, status);
    }

    public GrpcErrorException(GrpcError error, GrpcStatus status) {
        super("gRPC error status: " + status.name());
        this.error = error;
        this.status = status;
    }

    public GrpcError error() {
        return this.error;
    }

    public GrpcStatus status() {
        return this.status;
    }
}

