/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientBuilder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientBuilder;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.impl.GrpcClientImpl;

public class GrpcClientBuilderImpl<C extends GrpcClient>
implements GrpcClientBuilder<C> {
    private final Vertx vertx;
    private GrpcClientOptions options;
    private HttpClientOptions transportOptions;
    private AddressResolver addressResolver;
    private LoadBalancer loadBalancer;

    public GrpcClientBuilderImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public GrpcClientBuilderImpl<C> with(GrpcClientOptions options) {
        this.options = options == null ? null : new GrpcClientOptions(options);
        return this;
    }

    @Override
    public GrpcClientBuilderImpl<C> with(HttpClientOptions transportOptions) {
        this.transportOptions = transportOptions == null ? null : new HttpClientOptions(transportOptions);
        return this;
    }

    @Override
    public GrpcClientBuilderImpl<C> withAddressResolver(AddressResolver resolver) {
        this.addressResolver = resolver;
        return this;
    }

    @Override
    public GrpcClientBuilderImpl<C> withLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    @Override
    public C build() {
        GrpcClientOptions options;
        HttpClientOptions transportOptions = this.transportOptions;
        if (transportOptions == null) {
            transportOptions = new HttpClientOptions().setHttp2ClearTextUpgrade(false);
        }
        transportOptions = transportOptions.setProtocolVersion(HttpVersion.HTTP_2);
        HttpClientBuilder transportBuilder = this.vertx.httpClientBuilder().with(transportOptions);
        if (this.loadBalancer != null) {
            transportBuilder.withLoadBalancer(this.loadBalancer);
        }
        if (this.addressResolver != null) {
            transportBuilder.withAddressResolver(this.addressResolver);
        }
        if ((options = this.options) == null) {
            options = new GrpcClientOptions();
        }
        return this.create(this.vertx, options, (HttpClient)transportBuilder.build());
    }

    protected C create(Vertx vertx, GrpcClientOptions options, HttpClient transport) {
        GrpcClientImpl client = new GrpcClientImpl(vertx, options, transport, true);
        return (C)client;
    }
}

