/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class GrpcClientResponseImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcClientResponseImpl<Req, Resp>, Resp>
implements GrpcClientResponse<Req, Resp> {
    private final GrpcClientRequestImpl<Req, Resp> request;
    private final HttpClientResponse httpResponse;
    private GrpcStatus status;
    private String statusMessage;

    public GrpcClientResponseImpl(ContextInternal context, GrpcClientRequestImpl<Req, Resp> request, WireFormat format, long maxMessageSize, GrpcStatus status, HttpClientResponse httpResponse, GrpcMessageDecoder<Resp> messageDecoder) {
        super((Context)context, (ReadStream)httpResponse, httpResponse.headers().get("grpc-encoding"), format, maxMessageSize, messageDecoder);
        this.request = request;
        this.httpResponse = httpResponse;
        this.status = status;
    }

    public MultiMap headers() {
        return this.httpResponse.headers();
    }

    @Override
    public MultiMap trailers() {
        return this.httpResponse.trailers();
    }

    protected void handleEnd() {
        this.request.cancelTimeout();
        if (this.status == null) {
            String responseStatus = this.httpResponse.getTrailer("grpc-status");
            this.status = responseStatus != null ? GrpcStatus.valueOf((int)Integer.parseInt(responseStatus)) : GrpcStatus.UNKNOWN;
        }
        super.handleEnd();
        if (!this.request.isTrailersSent()) {
            this.request.cancel();
        }
    }

    @Override
    public GrpcStatus status() {
        return this.status;
    }

    @Override
    public String statusMessage() {
        String msg;
        if (this.status != null && this.status != GrpcStatus.OK && (msg = this.httpResponse.getHeader("grpc-message")) != null) {
            this.statusMessage = QueryStringDecoder.decodeComponent((String)msg, (Charset)StandardCharsets.UTF_8);
        }
        return this.statusMessage;
    }

    public Future<Void> end() {
        return super.end().compose(v -> {
            if (this.status() == GrpcStatus.OK) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((String)("Invalid gRPC status " + this.status));
        });
    }

    @Override
    public GrpcClientResponseImpl<Req, Resp> handler(Handler<Resp> handler) {
        if (handler != null) {
            return (GrpcClientResponseImpl)this.messageHandler(msg -> {
                Object decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    this.request.cancel();
                    return;
                }
                handler.handle(decoded);
            });
        }
        return (GrpcClientResponseImpl)this.messageHandler(null);
    }
}

