/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static String unescapeEntity(String input) {
        if (input == null || input.trim().length() == 0) {
            return "";
        }
        if (input.startsWith("#")) {
            String withoutPrefix = input.substring(1);
            if (!withoutPrefix.isEmpty() && withoutPrefix.startsWith("x")) {
                withoutPrefix = withoutPrefix.substring(1);
                return EntityUtils.parseAsHexa(input, withoutPrefix);
            }
            return EntityUtils.parseAsDecimal(input, withoutPrefix);
        }
        if (input.startsWith("u")) {
            String withoutPrefix = input.substring(1);
            return EntityUtils.parseAsHexa(input, withoutPrefix);
        }
        return "&" + input + ";";
    }

    private static String parseAsDecimal(String input, String withoutPrefix) {
        try {
            int parsed = Integer.parseInt(withoutPrefix);
            return Character.toString((char)parsed);
        }
        catch (NumberFormatException e) {
            return input;
        }
    }

    private static String parseAsHexa(String input, String withoutPrefix) {
        try {
            int parsed = (int)Long.parseLong(withoutPrefix, 16);
            return Character.toString((char)parsed);
        }
        catch (NumberFormatException e) {
            return input;
        }
    }
}

