/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.Section;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DB2Package {
    private static final Logger LOG = Logger.getLogger(DB2Package.class.getName());
    private static final int MAX_SECTIONS_SMALL_PKG = 64;
    private static final int MAX_SECTIONS_LARGE_PKG = 384;
    final String name;
    final String cursorNamePrefix;
    final int maxSections;
    byte[] pkgNameConsistencyBytes;
    final ConcurrentLinkedDeque<Section> freeSections = new ConcurrentLinkedDeque();
    private AtomicInteger nextAvailableSectionNumber = new AtomicInteger(1);

    public DB2Package(boolean isSmallPackage, int pkgNum) {
        this.maxSections = isSmallPackage ? 64 : 384;
        String config = (isSmallPackage ? (char)'S' : 'L') + "H2";
        String pkgNumStr = pkgNum < 16 ? "0" + Integer.toHexString(pkgNum) : Integer.toHexString(pkgNum);
        this.name = "SYS" + config + pkgNumStr;
        this.cursorNamePrefix = "SQL_CUR" + config + pkgNumStr + 'C';
    }

    boolean isSmallPackage() {
        return this.maxSections == 64;
    }

    int sectionsInUse() {
        return this.nextAvailableSectionNumber.get() - 1 - this.freeSections.size();
    }

    Section getFreeSection() {
        Section s = this.freeSections.poll();
        if (s != null) {
            s.use();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Using existing section " + s);
            }
            return s;
        }
        int sectionNumber = this.nextAvailableSectionNumber.getAndIncrement();
        if (sectionNumber > this.maxSections) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("All sections in use for package " + this);
            }
            return null;
        }
        return new Section(this, sectionNumber);
    }

    public String toString() {
        return super.toString() + "{name=" + this.name + ", freeSections=" + this.freeSections.size() + ",nextSection=" + this.nextAvailableSectionNumber + ", maxSections=" + this.maxSections + "}";
    }
}

