/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;

class CloseConnectionCommandCodec
extends CommandCodec<Void, CloseConnectionCommand> {
    CloseConnectionCommandCodec(CloseConnectionCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        ByteBuf packet = this.allocateBuffer();
        DRDAQueryRequest closeCursor = new DRDAQueryRequest(packet, encoder.socketConnection.connMetadata);
        closeCursor.buildRDBCMM();
        closeCursor.completeCommand();
        this.sendNonSplitPacket(packet);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        DRDAQueryResponse closeCursor = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        closeCursor.readLocalCommit();
        this.encoder.chctx.channel().close();
    }
}

