/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transports;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringChannelOption;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.transport.Transport;

public class IoUringTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    @Override
    public boolean supportsDomainSockets() {
        return false;
    }

    @Override
    public boolean supportFileRegion() {
        return false;
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            throw new IllegalArgumentException("Domain socket not supported by IOUring transport");
        }
        return Transport.super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return IoUring.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return IoUring.unavailabilityCause();
    }

    @Override
    public IoHandlerFactory ioHandlerFactory() {
        return IoUringIoHandler.newFactory();
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new IoUringDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new IoUringDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IoUringSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IoUringServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(IoUringChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        Transport.super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        bootstrap.option(IoUringChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        if (options.isTcpFastOpen()) {
            bootstrap.option(IoUringChannelOption.TCP_FASTOPEN, (Object)(options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0));
        }
        bootstrap.childOption(IoUringChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.childOption(IoUringChannelOption.TCP_CORK, (Object)options.isTcpCork());
        Transport.super.configure(options, false, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, int connectTimeout, boolean domainSocket, Bootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        if (options.isTcpFastOpen()) {
            bootstrap.option(IoUringChannelOption.TCP_FASTOPEN_CONNECT, (Object)options.isTcpFastOpen());
        }
        bootstrap.option(IoUringChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.option(IoUringChannelOption.TCP_CORK, (Object)options.isTcpCork());
        Transport.super.configure(options, connectTimeout, false, bootstrap);
    }
}

