/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi;

import io.vertx.core.impl.VertxBootstrapImpl;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;

public interface VertxTracerFactory
extends VertxServiceProvider {
    public static final VertxTracerFactory NOOP = options -> VertxTracer.NOOP;

    @Override
    default public void init(VertxBootstrap bootstrap) {
        VertxBootstrapImpl builder = (VertxBootstrapImpl)bootstrap;
        if (builder.tracer() == null) {
            TracingOptions tracingOptions = builder.options().getTracingOptions();
            if (tracingOptions == null) {
                tracingOptions = this.newOptions();
            }
            builder.tracer(this.tracer(tracingOptions));
        }
    }

    public VertxTracer tracer(TracingOptions var1);

    default public TracingOptions newOptions() {
        return new TracingOptions();
    }

    default public TracingOptions newOptions(JsonObject jsonObject) {
        return new TracingOptions(jsonObject);
    }
}

