/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.internal.net.SslChannelProvider;
import io.vertx.core.internal.net.SslHandshakeCompletionHandler;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.VertxConnection;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class NetSocketImpl
extends VertxConnection
implements NetSocketInternal {
    private final String writeHandlerID;
    private final SslContextManager sslContextManager;
    private final SSLOptions sslOptions;
    private final SocketAddress remoteAddress;
    private final TCPMetrics metrics;
    private final InboundMessageQueue<Object> pending;
    private final String negotiatedApplicationLayerProtocol;
    private Handler<Void> endHandler;
    private volatile Handler<Void> drainHandler;
    private MessageConsumer registration;
    private Handler<Buffer> handler;
    private MessageHandler messageHandler;
    private Handler<Void> readCompletionHandler;
    private Handler<Object> eventHandler;

    public NetSocketImpl(ContextInternal context, ChannelHandlerContext channel, SslContextManager sslContextManager, SSLOptions sslOptions, TCPMetrics metrics, boolean registerWriteHandler) {
        this(context, channel, null, sslContextManager, sslOptions, metrics, null, registerWriteHandler);
    }

    public NetSocketImpl(final ContextInternal context, ChannelHandlerContext channel, SocketAddress remoteAddress, SslContextManager sslContextManager, SSLOptions sslOptions, TCPMetrics metrics, String negotiatedApplicationLayerProtocol, boolean registerWriteHandler) {
        super(context, channel);
        this.sslContextManager = sslContextManager;
        this.sslOptions = sslOptions;
        this.writeHandlerID = registerWriteHandler ? "__vertx.net." + String.valueOf(UUID.randomUUID()) : null;
        this.remoteAddress = remoteAddress;
        this.metrics = metrics;
        this.messageHandler = new DataMessageHandler();
        this.negotiatedApplicationLayerProtocol = negotiatedApplicationLayerProtocol;
        this.pending = new InboundMessageQueue<Object>(context.eventLoop(), context.executor()){

            @Override
            protected void handleResume() {
                NetSocketImpl.this.doResume();
            }

            @Override
            protected void handlePause() {
                NetSocketImpl.this.doPause();
            }

            @Override
            protected void handleMessage(Object msg) {
                if (msg == InboundBuffer.END_SENTINEL) {
                    Handler<Void> handler = NetSocketImpl.this.endHandler();
                    if (handler != null) {
                        context.dispatch(handler);
                    }
                } else {
                    Handler<Buffer> handler = NetSocketImpl.this.handler();
                    if (handler != null) {
                        context.dispatch((Buffer)msg, handler);
                    }
                }
            }
        };
    }

    void registerEventBusHandler() {
        if (this.writeHandlerID != null) {
            Handler<Message> writeHandler = msg -> this.write((Buffer)msg.body());
            this.registration = this.vertx.eventBus().localConsumer(this.writeHandlerID).handler(writeHandler);
        }
    }

    void unregisterEventBusHandler() {
        if (this.registration != null) {
            MessageConsumer consumer = this.registration;
            this.registration = null;
            consumer.unregister();
        }
    }

    @Override
    public TCPMetrics metrics() {
        return this.metrics;
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public Future<Void> writeMessage(Object message) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeToChannel(message, promise);
        return promise.future();
    }

    @Override
    public String applicationLayerProtocol() {
        return this.negotiatedApplicationLayerProtocol;
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeMessage(((BufferInternal)data).getByteBuf());
    }

    @Override
    public Future<Void> write(String str) {
        return this.writeMessage(Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8));
    }

    @Override
    public Future<Void> write(String str, String enc) {
        return this.writeMessage(Unpooled.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc)));
    }

    private synchronized Handler<Buffer> handler() {
        return this.handler;
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
        this.handler = dataHandler;
        return this;
    }

    private synchronized Handler<Object> messageHandler() {
        return this.messageHandler;
    }

    @Override
    public synchronized NetSocketInternal messageHandler(final Handler<Object> handler) {
        this.messageHandler = handler == null ? new DataMessageHandler() : new MessageHandler(){

            @Override
            public void pause() {
                NetSocketImpl.this.doPause();
            }

            @Override
            public void fetch(long amount) {
                if (amount != Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Only accepts resume");
                }
                NetSocketImpl.this.doResume();
            }

            @Override
            public void handle(Object msg) {
                NetSocketImpl.this.context.emit(msg, handler);
            }
        };
        return this;
    }

    private synchronized Handler<Void> readCompletionHandler() {
        return this.readCompletionHandler;
    }

    @Override
    public synchronized NetSocketInternal readCompletionHandler(Handler<Void> handler) {
        this.readCompletionHandler = handler;
        return this;
    }

    @Override
    public synchronized NetSocketInternal eventHandler(Handler<Object> handler) {
        this.eventHandler = handler;
        return this;
    }

    @Override
    public synchronized NetSocket pause() {
        this.messageHandler.pause();
        return this;
    }

    @Override
    public NetSocket fetch(long amount) {
        this.messageHandler.fetch(amount);
        return this;
    }

    @Override
    public synchronized NetSocket resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return super.writeQueueFull();
    }

    @Override
    protected void handleWriteQueueDrained() {
        Handler<Void> handler = this.drainHandler;
        if (handler != null) {
            this.context.emit(null, handler);
        }
    }

    private synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        return this;
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        RandomAccessFile raf;
        PromiseInternal promise = this.context.promise();
        File file = this.vertx.fileResolver().resolve(filename);
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        long actualLength = Math.min(length, file.length() - offset);
        long actualOffset = Math.min(offset, file.length());
        ChannelFuture fut = this.sendFile(raf.getChannel(), actualOffset, actualLength);
        fut.addListener(promise);
        return promise.future().andThen(ar -> {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Override
    public NetSocketImpl exceptionHandler(Handler<Throwable> handler) {
        return (NetSocketImpl)super.exceptionHandler(handler);
    }

    @Override
    public NetSocketImpl closeHandler(Handler<Void> handler) {
        return (NetSocketImpl)super.closeHandler(handler);
    }

    @Override
    public Future<Void> upgradeToSsl(SSLOptions sslOptions, String serverName, Buffer upgrade) {
        return this.sslUpgrade(serverName, sslOptions != null ? sslOptions : this.sslOptions, upgrade != null ? ((BufferInternal)upgrade).getByteBuf() : Unpooled.EMPTY_BUFFER);
    }

    private Future<Void> sslUpgrade(String serverName, SSLOptions sslOptions, ByteBuf msg) {
        if (sslOptions == null) {
            return this.context.failedFuture("Missing SSL options");
        }
        if (this.remoteAddress != null && !(sslOptions instanceof ClientSSLOptions)) {
            return this.context.failedFuture("Client socket upgrade must use ClientSSLOptions");
        }
        if (this.remoteAddress == null && !(sslOptions instanceof ServerSSLOptions)) {
            return this.context.failedFuture("Server socket upgrade must use ServerSSLOptions");
        }
        if (this.chctx.pipeline().get("ssl") == null) {
            AsyncResult f;
            this.doPause();
            if (sslOptions instanceof ClientSSLOptions) {
                ClientSSLOptions clientSSLOptions = (ClientSSLOptions)sslOptions;
                f = this.sslContextManager.resolveSslContextProvider(sslOptions, clientSSLOptions.getHostnameVerificationAlgorithm(), null, null, this.context).map(p -> new SslChannelProvider(this.context.owner(), (SslContextProvider)p, false));
            } else {
                ServerSSLOptions serverSSLOptions = (ServerSSLOptions)sslOptions;
                ClientAuth clientAuth = serverSSLOptions.getClientAuth();
                if (clientAuth == null) {
                    clientAuth = ClientAuth.NONE;
                }
                f = this.sslContextManager.resolveSslContextProvider(sslOptions, null, clientAuth, null, this.context).map(p -> new SslChannelProvider(this.context.owner(), (SslContextProvider)p, serverSSLOptions.isSni()));
            }
            return f.compose(provider -> {
                PromiseInternal p = this.context.promise();
                ChannelPromise promise = this.chctx.newPromise();
                this.writeToChannel(msg, true, promise);
                promise.addListener(res -> {
                    if (res.isSuccess()) {
                        ChannelHandler sslHandler;
                        ChannelPromise channelPromise = this.chctx.newPromise();
                        this.chctx.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler((Promise<Void>)channelPromise));
                        if (sslOptions instanceof ClientSSLOptions) {
                            ClientSSLOptions clientSSLOptions = (ClientSSLOptions)sslOptions;
                            sslHandler = provider.createClientSslHandler(this.remoteAddress, serverName, sslOptions.isUseAlpn(), clientSSLOptions.getSslHandshakeTimeout(), clientSSLOptions.getSslHandshakeTimeoutUnit());
                        } else {
                            sslHandler = provider.createServerHandler(sslOptions.isUseAlpn(), sslOptions.getSslHandshakeTimeout(), sslOptions.getSslHandshakeTimeoutUnit(), HttpUtils.socketAddressToHostAndPort(this.chctx.channel().remoteAddress()));
                        }
                        this.chctx.pipeline().addFirst("ssl", sslHandler);
                        channelPromise.addListener((GenericFutureListener)p);
                    } else {
                        p.fail(res.cause());
                    }
                });
                return p.future();
            }).transform(ar -> {
                this.doResume();
                return (Future)ar;
            });
        }
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    @Override
    protected void handleShutdown(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
    }

    @Override
    protected void handleClosed() {
        this.pending.write(InboundBuffer.END_SENTINEL);
        super.handleClosed();
    }

    @Override
    public void handleMessage(Object msg) {
        Handler<Object> handler = this.messageHandler();
        handler.handle(msg);
    }

    @Override
    protected void handleReadComplete() {
        Handler<Void> handler = this.readCompletionHandler();
        if (handler != null) {
            this.context.emit(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleEvent(Object event) {
        Handler<Object> handler;
        NetSocketImpl netSocketImpl = this;
        synchronized (netSocketImpl) {
            handler = this.eventHandler;
        }
        if (handler != null) {
            this.context.emit(event, handler);
        } else {
            super.handleEvent(event);
        }
    }

    @Override
    public NetSocketImpl shutdownHandler(@Nullable Handler<Void> handler) {
        super.shutdownHandler(handler);
        return this;
    }

    private class DataMessageHandler
    implements MessageHandler {
        private DataMessageHandler() {
        }

        @Override
        public void handle(Object msg) {
            if (msg instanceof ByteBuf) {
                BufferInternal buffer = BufferInternal.safeBuffer((ByteBuf)msg);
                NetSocketImpl.this.pending.write(buffer);
            } else {
                this.handleInvalid(msg);
            }
        }

        @Override
        public void pause() {
            NetSocketImpl.this.pending.pause();
        }

        @Override
        public void fetch(long amount) {
            NetSocketImpl.this.pending.fetch(amount);
        }

        private void handleInvalid(Object msg) {
            if (msg instanceof ReferenceCounted && !(msg instanceof ByteBuf)) {
                ReferenceCounted refCounter = (ReferenceCounted)msg;
                refCounter.release();
            }
        }
    }

    static interface MessageHandler
    extends Handler<Object> {
        public void pause();

        public void fetch(long var1);
    }
}

