/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.verticle;

import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.impl.ServiceHelper;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.deployment.DefaultDeployment;
import io.vertx.core.impl.verticle.JavaVerticleFactory;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.deployment.Deployment;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.internal.deployment.DeploymentManager;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.spi.VerticleFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class VerticleManager {
    private final Logger log;
    private final VertxImpl vertx;
    private final DeploymentManager deploymentManager;
    private final Map<String, List<VerticleFactory>> verticleFactories = new ConcurrentHashMap<String, List<VerticleFactory>>();
    private final List<VerticleFactory> defaultFactories = new ArrayList<VerticleFactory>();

    public VerticleManager(VertxInternal vertx, Logger log, DeploymentManager deploymentManager) {
        this.vertx = (VertxImpl)vertx;
        this.deploymentManager = deploymentManager;
        this.log = log;
        this.loadVerticleFactories();
    }

    private void loadVerticleFactories() {
        List<VerticleFactory> factories = ServiceHelper.loadFactories(VerticleFactory.class);
        factories.forEach(this::registerVerticleFactory);
        JavaVerticleFactory defaultFactory = new JavaVerticleFactory();
        defaultFactory.init(this.vertx);
        this.defaultFactories.add(defaultFactory);
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        if (facts == null) {
            facts = new ArrayList<VerticleFactory>();
            this.verticleFactories.put(prefix, facts);
        }
        if (facts.contains(factory)) {
            throw new IllegalArgumentException("Factory already registered");
        }
        facts.add(factory);
        facts.sort((fact1, fact2) -> fact1.order() - fact2.order());
        factory.init(this.vertx);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        boolean removed = false;
        if (facts != null) {
            if (facts.remove(factory)) {
                removed = true;
            }
            if (facts.isEmpty()) {
                this.verticleFactories.remove(prefix);
            }
        }
        if (!removed) {
            throw new IllegalArgumentException("factory isn't registered");
        }
    }

    public Set<VerticleFactory> verticleFactories() {
        HashSet<VerticleFactory> facts = new HashSet<VerticleFactory>();
        for (List<VerticleFactory> list : this.verticleFactories.values()) {
            facts.addAll(list);
        }
        return facts;
    }

    private List<VerticleFactory> resolveFactories(String identifier) {
        List<VerticleFactory> factoryList = null;
        int pos = identifier.indexOf(58);
        String lookup = null;
        if (pos != -1) {
            lookup = identifier.substring(0, pos);
        } else {
            pos = identifier.lastIndexOf(46);
            if (pos != -1) {
                lookup = VerticleManager.getSuffix(pos, identifier);
            } else {
                factoryList = this.defaultFactories;
            }
        }
        if (factoryList == null && (factoryList = this.verticleFactories.get(lookup)) == null) {
            factoryList = this.defaultFactories;
        }
        return factoryList;
    }

    private static String getSuffix(int pos, String str) {
        if (pos + 1 >= str.length()) {
            throw new IllegalArgumentException("Invalid name: " + str);
        }
        return str.substring(pos + 1);
    }

    public Future<DeploymentContext> deployVerticle(String identifier, DeploymentOptions options) {
        ContextInternal callingContext = this.vertx.getOrCreateContext();
        ClassLoader loader = options.getClassLoader();
        if (loader == null) {
            loader = VerticleManager.getCurrentClassLoader();
        }
        return this.deployVerticle(identifier, options, callingContext, callingContext, loader);
    }

    private Future<DeploymentContext> deployVerticle(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        List<VerticleFactory> verticleFactories = this.resolveFactories(identifier);
        Iterator<VerticleFactory> iter = verticleFactories.iterator();
        return this.createDeployment(iter, null, identifier, options, parentContext, callingContext, cl).compose(deployment -> this.deploymentManager.deploy(parentContext.deployment(), callingContext, (Deployment)deployment));
    }

    private Future<Deployment> createDeployment(Iterator<VerticleFactory> iter, Throwable prevErr, String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        if (iter.hasNext()) {
            VerticleFactory verticleFactory = iter.next();
            return this.createDeployment(verticleFactory, identifier, options, callingContext, cl).recover(err -> this.createDeployment(iter, (Throwable)err, identifier, options, parentContext, callingContext, cl));
        }
        if (prevErr != null) {
            return callingContext.failedFuture(prevErr);
        }
        throw new UnsupportedOperationException();
    }

    private Future<Deployment> createDeployment(VerticleFactory verticleFactory, String identifier, DeploymentOptions options, ContextInternal callingContext, ClassLoader cl) {
        PromiseInternal<Callable<? extends Deployable>> p = callingContext.promise();
        try {
            verticleFactory.createVerticle2(identifier, cl, p);
        }
        catch (Exception e) {
            return callingContext.failedFuture(e);
        }
        return p.future().compose(callable -> this.createDeployment(options, (Deployable v) -> identifier, callingContext, cl, (Callable<? extends Deployable>)callable));
    }

    private Future<Deployment> createDeployment(DeploymentOptions options, Function<Deployable, String> identifierMapper, ContextInternal callingContext, ClassLoader tccl, Callable<? extends Deployable> verticleSupplier) {
        try {
            return Future.succeededFuture(DefaultDeployment.deployment(this.vertx, this.log, options, identifierMapper, tccl, verticleSupplier));
        }
        catch (Exception e) {
            return callingContext.failedFuture(e);
        }
    }

    private static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = VerticleManager.class.getClassLoader();
        }
        return cl;
    }
}

