/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.pool.CombinerExecutor;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Executor;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnection;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.pool.PoolWaiter;
import io.vertx.core.internal.pool.Task;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class SimpleConnectionPool<C>
implements ConnectionPool<C> {
    private static final Future POOL_CLOSED = Future.failedFuture("Pool closed");
    private static final VertxException POOL_CLOSED_EXCEPTION = new VertxException("Pool closed", true);
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> SAME_EVENT_LOOP_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.context().nettyEventLoop() != waiter.context().nettyEventLoop() || slot.available() <= 0L) continue;
            return slot;
        }
        return null;
    };
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> FIRST_AVAILABLE_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.available() <= 0L) continue;
            return slot;
        }
        return null;
    };
    private final PoolConnector<C> connector;
    private final int maxWaiters;
    private final int maxCapacity;
    private final int[] capacityFactors;
    private final Executor<SimpleConnectionPool<C>> sync;
    private final ListImpl list = new ListImpl();
    private boolean closed;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector;
    private Function<ContextInternal, ContextInternal> contextProvider;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> fallbackSelector;
    private final Slot<C>[] slots;
    private int size;
    private int capacity;
    private final Waiters<C> waiters;
    private int requests;

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes) {
        this(connector, maxSizes, -1);
    }

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes, int maxWaiters) {
        int i;
        int[] capacities = new int[maxSizes.length];
        int maxCapacity = 1;
        int numSlots = 0;
        for (i = 0; i < maxSizes.length; ++i) {
            int maxSize = maxSizes[i];
            if (maxSize < 1) {
                throw new IllegalArgumentException();
            }
            maxCapacity *= maxSize;
            numSlots = Math.max(numSlots, maxSize);
        }
        for (i = 0; i < maxSizes.length; ++i) {
            capacities[i] = maxCapacity / maxSizes[i];
        }
        this.capacityFactors = capacities;
        this.connector = connector;
        this.slots = new Slot[numSlots];
        this.size = 0;
        this.maxWaiters = maxWaiters;
        this.capacity = 0;
        this.maxCapacity = maxCapacity;
        this.sync = new CombinerExecutor<SimpleConnectionPool>(this);
        this.selector = SAME_EVENT_LOOP_SELECTOR;
        this.fallbackSelector = FIRST_AVAILABLE_SELECTOR;
        this.contextProvider = EVENT_LOOP_CONTEXT_PROVIDER;
        this.waiters = new Waiters();
    }

    @Override
    public ConnectionPool<C> connectionSelector(BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector) {
        this.selector = selector;
        return this;
    }

    @Override
    public ConnectionPool<C> contextProvider(Function<ContextInternal, ContextInternal> contextProvider) {
        this.contextProvider = contextProvider;
        return this;
    }

    private void execute(Executor.Action<SimpleConnectionPool<C>> action) {
        this.sync.submit(action);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void connect(Slot<C> slot, PoolWaiter<C> waiter) {
        slot.initiator = waiter;
        this.connector.connect(slot.context, slot).onComplete(ar -> {
            slot.initiator = null;
            if (ar.succeeded()) {
                this.execute(new ConnectSuccess(slot, (ConnectResult)ar.result(), waiter));
            } else {
                this.execute(new ConnectFailed(slot, ar.cause(), waiter));
            }
        });
    }

    private void setConcurrency(Slot<C> slot, long concurrency) {
        this.execute(new SetConcurrency<C>(slot, concurrency));
    }

    private void remove(Slot<C> removed) {
        this.execute(new Remove<C>(removed));
    }

    @Override
    public void evict(Predicate<C> predicate, Completable<List<C>> handler) {
        this.execute(new Evict<C>(predicate, handler));
    }

    @Override
    public void acquire(ContextInternal context, int kind, Completable<Lease<C>> handler) {
        this.execute(new Acquire<C>(context, PoolWaiter.NULL_LISTENER, this.capacityFactors[kind], handler));
    }

    @Override
    public void acquire(ContextInternal context, PoolWaiter.Listener<C> listener, int kind, Completable<Lease<C>> handler) {
        this.execute(new Acquire<C>(context, listener, this.capacityFactors[kind], handler));
    }

    @Override
    public void cancel(PoolWaiter<C> waiter, Completable<Boolean> handler) {
        this.execute(new Cancel<C>(waiter, handler));
    }

    private void recycle(LeaseImpl<C> lease) {
        if (lease.recycled) {
            throw new IllegalStateException("Attempt to recycle more than permitted");
        }
        lease.recycled = true;
        this.execute(new Recycle(lease.slot));
    }

    @Override
    public int waiters() {
        return this.waiters.size();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int requests() {
        return this.requests;
    }

    @Override
    public void close(Completable<List<Future<C>>> handler) {
        this.execute(new Close<C>(handler));
    }

    static class LazyFuture<T>
    extends FutureBase<T>
    implements Promise<T> {
        private final List<Completable<? super T>> handlers = new ArrayList<Completable<? super T>>();
        private Future<T> fut = null;

        LazyFuture() {
        }

        @Override
        public boolean tryComplete(T result) {
            this.handle(Future.succeededFuture(result));
            return true;
        }

        @Override
        public boolean tryFail(Throwable cause) {
            this.handle(Future.failedFuture(cause));
            return true;
        }

        @Override
        public Future<T> future() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(AsyncResult<T> event) {
            List<Completable<T>> h;
            Future f = (Future)event;
            LazyFuture lazyFuture = this;
            synchronized (lazyFuture) {
                this.fut = f;
                h = this.handlers;
            }
            for (Completable completable : h) {
                completable.complete(event.result(), event.cause());
            }
        }

        @Override
        public synchronized boolean isComplete() {
            return this.fut != null && this.fut.isComplete();
        }

        @Override
        public Future<T> onComplete(final Handler<AsyncResult<T>> handler) {
            this.addListener(new Completable<T>(){

                @Override
                public void complete(T result, Throwable failure) {
                    handler.handle(this);
                }
            });
            return this;
        }

        @Override
        public synchronized T result() {
            return this.fut != null ? (T)this.fut.result() : null;
        }

        @Override
        public Throwable cause() {
            return this.fut != null ? this.fut.cause() : null;
        }

        @Override
        public boolean succeeded() {
            return this.fut != null && this.fut.succeeded();
        }

        @Override
        public boolean failed() {
            return this.fut != null && this.fut.failed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(Completable<? super T> listener) {
            Future<T> f;
            LazyFuture lazyFuture = this;
            synchronized (lazyFuture) {
                f = this.fut;
                if (f == null) {
                    this.handlers.add(listener);
                    return;
                }
            }
            listener.complete(f.result(), f.cause());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(Completable<? super T> listener) {
            LazyFuture lazyFuture = this;
            synchronized (lazyFuture) {
                this.handlers.remove(listener);
            }
        }
    }

    class ListImpl
    extends AbstractList<PoolConnection<C>> {
        ListImpl() {
        }

        @Override
        public PoolConnection<C> get(int index) {
            return SimpleConnectionPool.this.slots[index];
        }

        @Override
        public int size() {
            return SimpleConnectionPool.this.size;
        }
    }

    private static class Waiters<C>
    implements Iterable<PoolWaiter<C>> {
        private final PoolWaiter<C> head = new PoolWaiter(null, null, 0, null);
        private int size;

        public Waiters() {
            this.head.prev = this.head;
            this.head.next = this.head.prev;
        }

        PoolWaiter<C> poll() {
            if (this.head.next == this.head) {
                return null;
            }
            PoolWaiter node = this.head.next;
            this.remove(node);
            return node;
        }

        void addLast(PoolWaiter<C> node) {
            if (node.queued) {
                throw new IllegalStateException();
            }
            node.queued = true;
            node.prev = this.head.prev;
            node.next = this.head;
            this.head.prev.next = node;
            this.head.prev = node;
            ++this.size;
        }

        void addFirst(PoolWaiter<C> node) {
            if (node.queued) {
                throw new IllegalStateException();
            }
            node.queued = true;
            node.prev = this.head;
            node.next = this.head.prev;
            this.head.next.prev = node;
            this.head.next = node;
            ++this.size;
        }

        boolean remove(PoolWaiter<C> node) {
            if (!node.queued) {
                return false;
            }
            node.next.prev = node.prev;
            node.prev.next = node.next;
            node.prev = null;
            node.next = null;
            node.queued = false;
            --this.size;
            return true;
        }

        List<PoolWaiter<C>> clear() {
            ArrayList<PoolWaiter<C>> lst = new ArrayList<PoolWaiter<C>>(this.size);
            this.forEach(lst::add);
            this.size = 0;
            this.head.prev = this.head;
            this.head.next = this.head.prev;
            return lst;
        }

        int size() {
            return this.size;
        }

        @Override
        public Iterator<PoolWaiter<C>> iterator() {
            return new Iterator<PoolWaiter<C>>(){
                PoolWaiter<C> current;
                {
                    this.current = head;
                }

                @Override
                public boolean hasNext() {
                    return this.current.next != head;
                }

                @Override
                public PoolWaiter<C> next() {
                    if (this.current.next == head) {
                        throw new NoSuchElementException();
                    }
                    try {
                        PoolWaiter poolWaiter = this.current.next;
                        return poolWaiter;
                    }
                    finally {
                        this.current = this.current.next;
                    }
                }
            };
        }
    }

    private static class Close<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Completable<List<Future<C>>> handler;

        private Close(Completable<List<Future<C>>> handler) {
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (pool.closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.fail(POOL_CLOSED_EXCEPTION);
                    }
                };
            }
            pool.closed = true;
            final List waiters = pool.waiters.clear();
            final ArrayList list = new ArrayList();
            for (int i = 0; i < pool.size; ++i) {
                Slot slot = pool.slots[i];
                pool.slots[i] = null;
                PoolWaiter waiter = slot.initiator;
                if (waiter != null) {
                    waiters.add(slot.initiator);
                    slot.initiator.disposed = true;
                    slot.initiator = null;
                }
                pool.capacity -= slot.capacity;
                list.add(slot.result.future());
            }
            pool.size = 0;
            return new Task(){

                @Override
                public void run() {
                    waiters.forEach(w -> w.handler.fail(POOL_CLOSED_EXCEPTION));
                    handler.succeed(list);
                }
            };
        }
    }

    private static class Recycle<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;

        public Recycle(Slot<C> slot) {
            this.slot = slot;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (!pool.closed && this.slot.connection != null) {
                PoolWaiter waiter;
                if ((long)this.slot.usage <= this.slot.concurrency && (waiter = pool.waiters.poll()) != null) {
                    final LeaseImpl<C> lease = new LeaseImpl<C>(this.slot, waiter.handler);
                    return new Task(){

                        @Override
                        public void run() {
                            lease.emit();
                        }
                    };
                }
                --this.slot.usage;
            }
            return null;
        }
    }

    static class LeaseImpl<C>
    implements Lease<C> {
        private final Completable<Lease<C>> handler;
        private final Slot<C> slot;
        private final C connection;
        private boolean recycled;

        public LeaseImpl(Slot<C> slot, Completable<Lease<C>> handler) {
            this.handler = handler;
            this.slot = slot;
            this.connection = slot.connection;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public void recycle() {
            this.slot.pool.recycle(this);
        }

        void emit() {
            Future<LeaseImpl> fut = this.slot.context.succeededFuture(this);
            fut.onComplete(this.handler);
        }
    }

    private static class Cancel<C>
    extends Task
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final PoolWaiter<C> waiter;
        private final Completable<Boolean> handler;
        private boolean cancelled;

        public Cancel(PoolWaiter<C> waiter, Completable<Boolean> handler) {
            this.waiter = waiter;
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (pool.closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.fail(POOL_CLOSED_EXCEPTION);
                    }
                };
            }
            if (pool.waiters.remove(this.waiter)) {
                this.cancelled = true;
                this.waiter.disposed = true;
            } else if (!this.waiter.disposed) {
                this.waiter.disposed = true;
                this.cancelled = true;
            } else {
                this.cancelled = false;
            }
            return this;
        }

        @Override
        public void run() {
            this.handler.succeed(this.cancelled);
        }
    }

    private static class Acquire<C>
    extends PoolWaiter<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        public Acquire(ContextInternal context, PoolWaiter.Listener<C> listener, int capacity, Completable<Lease<C>> handler) {
            super(listener, context, capacity, handler);
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            if (pool.closed) {
                return new Task(){

                    @Override
                    public void run() {
                        Future fut = context.failedFuture("Pool closed");
                        fut.onComplete(handler);
                    }
                };
            }
            Slot slot1 = (Slot)pool.selector.apply(this, pool.list);
            if (slot1 != null) {
                ++slot1.usage;
                final LeaseImpl lease = new LeaseImpl(slot1, this.handler);
                return new Task(){

                    @Override
                    public void run() {
                        lease.emit();
                    }
                };
            }
            if (pool.capacity < pool.maxCapacity) {
                pool.capacity += this.capacity;
                ContextInternal connectionContext = pool.contextProvider.apply(this.context);
                final Slot<C> slot2 = new Slot<C>(pool, connectionContext, pool.size, this.capacity);
                pool.slots[pool.size++] = slot2;
                ++pool.requests;
                return new Task(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onConnect(this);
                        }
                        pool.connect(slot2, this);
                    }
                };
            }
            Slot slot3 = (Slot)pool.fallbackSelector.apply(this, pool.list);
            if (slot3 != null) {
                ++slot3.usage;
                final LeaseImpl lease = new LeaseImpl(slot3, this.handler);
                return new Task(){

                    @Override
                    public void run() {
                        lease.emit();
                    }
                };
            }
            if (pool.maxWaiters == -1 || pool.waiters.size() + pool.requests < pool.maxWaiters) {
                pool.waiters.addLast(this);
                if (this.listener != null) {
                    return new Task(){

                        @Override
                        public void run() {
                            listener.onEnqueue(this);
                        }
                    };
                }
                return null;
            }
            return new Task(){

                @Override
                public void run() {
                    Future fut = context.failedFuture(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + pool.maxWaiters));
                    fut.onComplete(handler);
                }
            };
        }
    }

    private static class Evict<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Predicate<C> predicate;
        private final Completable<List<C>> handler;

        public Evict(Predicate<C> predicate, Completable<List<C>> handler) {
            this.predicate = predicate;
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            Task head;
            if (pool.closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.fail(POOL_CLOSED_EXCEPTION);
                    }
                };
            }
            final ArrayList res = new ArrayList();
            ArrayList removed = new ArrayList();
            for (int i = pool.size - 1; i >= 0; --i) {
                Slot slot = pool.slots[i];
                if (slot.connection == null || slot.usage != 0 || !this.predicate.test(slot.connection)) continue;
                removed.add(slot);
                res.add(slot.connection);
            }
            Task tail = head = new Task(){

                @Override
                public void run() {
                    handler.succeed(res);
                }
            };
            for (Slot slot : removed) {
                Task next = new Remove<C>(slot).execute(pool);
                if (next == null) continue;
                tail.next(next);
                tail = next;
            }
            return head;
        }
    }

    private static class SetConcurrency<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final long concurrency;

        SetConcurrency(Slot<C> slot, long concurrency) {
            this.slot = slot;
            this.concurrency = concurrency;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (this.slot.connection != null) {
                long diff = this.concurrency - this.slot.concurrency;
                this.slot.concurrency += diff;
                if (diff > 0L) {
                    int m = (int)Math.min(this.slot.concurrency - (long)this.slot.usage, (long)pool.waiters.size());
                    if (m > 0) {
                        final LeaseImpl[] extra = new LeaseImpl[m];
                        for (int i = 0; i < m; ++i) {
                            extra[i] = new LeaseImpl<C>(this.slot, pool.waiters.poll().handler);
                        }
                        this.slot.usage += m;
                        return new Task(){

                            @Override
                            public void run() {
                                for (LeaseImpl lease : extra) {
                                    lease.emit();
                                }
                            }
                        };
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
    }

    private static class Remove<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        protected final Slot<C> removed;

        private Remove(Slot<C> removed) {
            this.removed = removed;
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            if (pool.closed || pool.slots[this.removed.index] != this.removed) {
                return null;
            }
            int w = this.removed.capacity;
            this.removed.usage = 0;
            this.removed.concurrency = 0L;
            this.removed.connection = null;
            this.removed.capacity = 0;
            final PoolWaiter waiter = pool.waiters.poll();
            if (waiter != null) {
                ContextInternal connectionContext = pool.contextProvider.apply(waiter.context);
                final Slot<C> slot = new Slot<C>(pool, connectionContext, this.removed.index, waiter.capacity);
                pool.capacity -= w;
                pool.capacity += waiter.capacity;
                pool.slots[this.removed.index] = slot;
                ++pool.requests;
                return new Task(){

                    @Override
                    public void run() {
                        if (waiter.listener != null) {
                            waiter.listener.onConnect(waiter);
                        }
                        pool.connect(slot, waiter);
                    }
                };
            }
            if (pool.size > 1) {
                Slot tmp = pool.slots[pool.size - 1];
                tmp.index = this.removed.index;
                pool.slots[this.removed.index] = tmp;
                pool.slots[pool.size - 1] = null;
                --pool.size;
                pool.capacity -= w;
                return null;
            }
            pool.slots[0] = null;
            --pool.size;
            pool.capacity -= w;
            return null;
        }
    }

    private static class ConnectFailed<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> removed;
        private final Throwable cause;
        private PoolWaiter<C> waiter;

        public ConnectFailed(Slot<C> removed, Throwable cause, PoolWaiter<C> waiter) {
            this.removed = removed;
            this.cause = cause;
            this.waiter = waiter;
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            Task removeTask;
            --pool.requests;
            if (this.waiter.disposed) {
                this.waiter = null;
            } else {
                this.waiter.disposed = true;
            }
            Task task = new Task(){

                @Override
                public void run() {
                    if (waiter != null) {
                        Throwable waiterFailure = pool.closed ? POOL_CLOSED_EXCEPTION : cause;
                        waiter.handler.fail(waiterFailure);
                    }
                    removed.result.fail(cause);
                }
            };
            if (!pool.closed && (removeTask = new Remove<C>(this.removed).execute(pool)) != null) {
                removeTask.next(task);
                task = removeTask;
            }
            return task;
        }
    }

    private static class ConnectSuccess<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final ConnectResult<C> result;
        private PoolWaiter<C> waiter;

        private ConnectSuccess(Slot<C> slot, ConnectResult<C> result, PoolWaiter<C> waiter) {
            this.slot = slot;
            this.result = result;
            this.waiter = waiter;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            LeaseImpl[] leases;
            int c;
            LeaseImpl<C> lease;
            int capacity = pool.capacityFactors[(int)this.result.weight()];
            int initialCapacity = this.slot.capacity;
            this.slot.connection = this.result.connection();
            this.slot.concurrency = this.result.concurrency();
            this.slot.capacity = capacity;
            this.slot.usage = 0;
            --pool.requests;
            pool.capacity += capacity - initialCapacity;
            if (pool.closed) {
                if (this.waiter.disposed) {
                    this.waiter = null;
                } else {
                    this.waiter.disposed = true;
                }
                return new Task(){

                    @Override
                    public void run() {
                        if (waiter != null) {
                            Future fut = slot.context.failedFuture("Pool closed");
                            fut.onComplete(waiter.handler);
                        }
                        slot.result.complete(slot.connection);
                    }
                };
            }
            long acquisitions = this.slot.concurrency;
            if (acquisitions == 0L) {
                if (!this.waiter.disposed) {
                    pool.waiters.addFirst(this.waiter);
                }
                return null;
            }
            if (this.waiter.disposed) {
                lease = null;
                c = 0;
            } else {
                lease = new LeaseImpl<C>(this.slot, this.waiter.handler);
                c = 1;
                this.waiter.disposed = true;
                --acquisitions;
            }
            int m = (int)Math.min(acquisitions, (long)pool.waiters.size());
            if (m > 0) {
                c += m;
                leases = new LeaseImpl[m];
                for (int i = 0; i < m; ++i) {
                    leases[i] = new LeaseImpl<C>(this.slot, pool.waiters.poll().handler);
                }
            } else {
                leases = null;
            }
            this.slot.usage = c;
            return new Task(){

                @Override
                public void run() {
                    if (lease != null) {
                        lease.emit();
                    }
                    if (leases != null) {
                        for (LeaseImpl lease2 : leases) {
                            lease2.emit();
                        }
                    }
                    slot.result.complete(slot.connection);
                }
            };
        }
    }

    static class Slot<C>
    implements PoolConnector.Listener,
    PoolConnection<C> {
        private final SimpleConnectionPool<C> pool;
        private final ContextInternal context;
        private final Promise<C> result;
        private PoolWaiter<C> initiator;
        private C connection;
        private int index;
        private int usage;
        private long concurrency;
        private int capacity;

        public Slot(SimpleConnectionPool<C> pool, ContextInternal context, int index, int capacity) {
            this.pool = pool;
            this.context = context;
            this.connection = null;
            this.usage = 0;
            this.index = index;
            this.capacity = capacity;
            this.result = context.promise();
        }

        @Override
        public void onRemove() {
            this.pool.remove(this);
        }

        @Override
        public void onConcurrencyChange(long concurrency) {
            this.pool.setConcurrency(this, concurrency);
        }

        @Override
        public ContextInternal context() {
            return this.context;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public int usage() {
            return this.usage;
        }

        @Override
        public long available() {
            return this.concurrency - (long)this.usage;
        }

        @Override
        public long concurrency() {
            return this.concurrency;
        }
    }
}

