/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableUtils {
    public static byte[] toBytes(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static Object fromBytes(byte[] bytes, ObjectInputStreamFactory factory) {
        Object object;
        block8: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = factory.create(bais);
            try {
                object = ois.readObject();
                if (ois == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            ois.close();
        }
        return object;
    }

    private SerializableUtils() {
    }

    @FunctionalInterface
    public static interface ObjectInputStreamFactory {
        public ObjectInputStream create(ByteArrayInputStream var1) throws IOException;
    }
}

