/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.http.impl.Http1xConnection;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerWebSocketHandshaker;
import io.vertx.core.http.impl.VertxFullHttpResponse;
import io.vertx.core.http.impl.VertxHttpObject;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.MessageWrite;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Http1xServerConnection
extends Http1xConnection
implements HttpServerConnection {
    private final String serverOrigin;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final TracingPolicy tracingPolicy;
    private final boolean eagerCreateRequestQueue;
    private Http1xServerRequest requestInProgress;
    private Http1xServerRequest responseInProgress;
    private boolean wantClose;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<HttpServerRequest> invalidRequestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;
    final SslContextManager sslContextManager;
    final boolean strictThreadMode;

    public Http1xServerConnection(ThreadingModel threadingModel, Supplier<ContextInternal> streamContextSupplier, SslContextManager sslContextManager, HttpServerOptions options, ChannelHandlerContext chctx, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(context, chctx, options.getStrictThreadMode() && threadingModel == ThreadingModel.EVENT_LOOP);
        this.serverOrigin = serverOrigin;
        this.streamContextSupplier = streamContextSupplier;
        this.options = options;
        this.sslContextManager = sslContextManager;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
        this.tracingPolicy = options.getTracingPolicy();
        this.wantClose = false;
        this.strictThreadMode = options.getStrictThreadMode() && threadingModel == ThreadingModel.EVENT_LOOP;
        this.eagerCreateRequestQueue = threadingModel != ThreadingModel.EVENT_LOOP;
    }

    @Override
    protected void handleShutdown(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
        super.handleShutdown(reason, timeout, unit, promise);
        if (this.responseInProgress == null) {
            this.closeInternal();
        }
    }

    TracingPolicy tracingPolicy() {
        return this.tracingPolicy;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void handleMessage(Object msg) {
        assert (msg != null);
        if (this.requestInProgress == null && (this.shutdownInitiated || this.wantClose)) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onEnd();
        } else if (msg instanceof DefaultHttpRequest) {
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            ContextInternal requestCtx = this.streamContextSupplier.get();
            Http1xServerRequest req = new Http1xServerRequest(this, (HttpRequest)request, requestCtx);
            if (this.eagerCreateRequestQueue) {
                req.resume();
            }
            this.requestInProgress = req;
            if (this.responseInProgress != null) {
                this.doPause();
                return;
            }
            boolean keepAlive = HttpUtils.isKeepAlive((HttpRequest)request);
            this.responseInProgress = this.requestInProgress;
            this.wantClose = !keepAlive;
            req.handleBegin(keepAlive);
            Handler<HttpServerRequest> handler = request.decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            req.context.emit(req, handler);
        } else {
            this.handleOther(msg);
        }
    }

    private void handleOther(Object msg) {
        if (msg instanceof DefaultHttpContent || msg instanceof HttpContent) {
            this.onContent(msg);
        }
    }

    private void onContent(Object msg) {
        HttpContent content = (HttpContent)msg;
        if (!content.decoderResult().isSuccess()) {
            this.handleError((HttpObject)content);
            return;
        }
        BufferInternal buffer = BufferInternal.safeBuffer(content.content());
        Http1xServerRequest request = this.requestInProgress;
        request.handleContent(buffer);
        if (content instanceof LastHttpContent) {
            this.onEnd();
        }
    }

    private void onEnd() {
        Http1xServerRequest request = this.requestInProgress;
        this.requestInProgress = null;
        boolean tryClose = (this.wantClose || this.shutdownInitiated) && this.responseInProgress == null;
        request.handleEnd();
        if (tryClose) {
            this.closeInternal();
        }
    }

    void write(final VertxHttpObject msg, final Promise<Void> promise) {
        this.writeToChannel(new MessageWrite(){

            @Override
            public void write() {
                Http1xServerConnection.this.write((Object)msg, false, promise);
                if (msg.isEnded()) {
                    Http1xServerConnection.this.responseComplete();
                }
            }

            @Override
            public void cancel(Throwable cause) {
                promise.fail(cause);
            }
        });
    }

    void responseComplete() {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            if (Metrics.METRICS_ENABLED) {
                this.reportResponseComplete();
            }
            Http1xServerRequest request = this.responseInProgress;
            this.responseInProgress = null;
            DecoderResult result = request.decoderResult();
            if (result.isSuccess()) {
                if (this.requestInProgress != request) {
                    Http1xServerRequest next = this.requestInProgress;
                    if (next != null) {
                        this.handleNext(next);
                    } else if (this.wantClose || this.shutdownInitiated) {
                        this.closeInternal();
                    }
                }
            } else {
                ChannelPromise channelFuture = this.newChannelPromise();
                this.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
                channelFuture.addListener(fut -> this.fail(result.cause()));
            }
        } else {
            eventLoop.execute(this::responseComplete);
        }
    }

    private void handleNext(Http1xServerRequest next) {
        boolean keepAlive = HttpUtils.isKeepAlive(next.nettyRequest());
        this.responseInProgress = next;
        this.wantClose |= !keepAlive;
        next.handleBegin(keepAlive);
        next.context.emit(next, next_ -> {
            Handler<HttpServerRequest> handler = next_.nettyRequest().decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            handler.handle((HttpServerRequest)next_);
        });
        this.doResume();
    }

    private void reportResponseComplete() {
        Http1xServerRequest request = this.responseInProgress;
        if (this.metrics != null) {
            this.flushBytesWritten();
            if (request.reportMetricsFailed) {
                this.metrics.requestReset(request.metric());
            } else {
                this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
            }
        }
        VertxTracer tracer = this.context.tracer();
        Object trace = request.trace();
        if (tracer != null && trace != null) {
            tracer.sendResponse(request.context, request.response(), trace, null, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
    }

    String serverOrigin() {
        return this.serverOrigin;
    }

    void createWebSocket(Http1xServerRequest request, PromiseInternal<ServerWebSocketHandshake> promise) {
        this.wantClose = false;
        this.context.execute(() -> {
            if (request != this.responseInProgress) {
                promise.fail("Invalid request");
            } else if (!(request.nettyRequest() instanceof FullHttpRequest)) {
                promise.fail(new IllegalStateException());
            } else {
                WebSocketServerHandshaker handshaker;
                try {
                    handshaker = this.createHandshaker(request);
                }
                catch (WebSocketHandshakeException e) {
                    promise.fail(e);
                    return;
                }
                promise.complete(new ServerWebSocketHandshaker(request, handshaker, this.options));
            }
        });
    }

    public WebSocketServerHandshaker createHandshaker(Http1xServerRequest request) throws WebSocketHandshakeException {
        WebSocketDecoderConfig config;
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker shake;
        String wsURL;
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            throw new WebSocketHandshakeException("Invalid connection header");
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            throw new WebSocketHandshakeException("Invalid HTTP method");
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            throw new WebSocketHandshakeException("Invalid WebSocket location", (Throwable)e);
        }
        String subProtocols = null;
        if (this.options.getWebSocketSubProtocols() != null) {
            subProtocols = String.join((CharSequence)",", this.options.getWebSocketSubProtocols());
        }
        if ((shake = (factory = new WebSocketServerHandshakerFactory(wsURL, subProtocols, config = WebSocketDecoderConfig.newBuilder().allowExtensions(this.options.getPerMessageWebSocketCompressionSupported() || this.options.getPerFrameWebSocketCompressionSupported()).maxFramePayloadLength(this.options.getMaxWebSocketFrameSize()).allowMaskMismatch(this.options.isAcceptUnmaskedFrames()).closeOnProtocolViolation(false).build())).newHandshaker(request.nettyRequest())) != null) {
            return shake;
        }
        request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        throw new WebSocketHandshakeException("Invalid WebSocket version");
    }

    public void netSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<NetSocket> fut = this.netSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<NetSocket> netSocket() {
        PromiseInternal<NetSocket> promise = this.context.promise();
        this.netSocket(promise);
        return promise.future();
    }

    void netSocket(Promise<NetSocket> promise) {
        this.context.execute(() -> {
            this.flush();
            ChannelPipeline pipeline = this.chctx.pipeline();
            ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
            if (compressor != null) {
                pipeline.remove(compressor);
            }
            pipeline.remove("httpDecoder");
            if (pipeline.get("chunkedWriter") != null) {
                pipeline.remove("chunkedWriter");
            }
            pipeline.replace("handler", "handler", VertxHandler.create(ctx -> {
                NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, this.sslContextManager, this.options.getSslOptions(), this.metrics, false){

                    @Override
                    protected void handleClosed() {
                        if (Http1xServerConnection.this.metrics != null) {
                            Http1xServerRequest request = Http1xServerConnection.this.responseInProgress;
                            Http1xServerConnection.this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
                        }
                        super.handleClosed();
                    }

                    @Override
                    public synchronized void handleMessage(Object msg) {
                        if (msg instanceof HttpContent) {
                            ReferenceCountUtil.release((Object)msg);
                            return;
                        }
                        super.handleMessage(msg);
                    }
                };
                socket.metric(this.metric());
                return socket;
            }));
            pipeline.remove("httpEncoder");
            VertxHandler handler = (VertxHandler)pipeline.get("handler");
            promise.complete((NetSocket)handler.getConnection());
        });
    }

    @Override
    protected void handleWriteQueueDrained() {
        if (this.responseInProgress != null) {
            ContextInternal context = this.responseInProgress.context;
            Handler<Void> handler = this.responseInProgress.response()::handleWriteQueueDrained;
            context.execute(handler);
        } else {
            super.handleWriteQueueDrained();
        }
    }

    void write100Continue(Promise<Void> promise) {
        this.write(new VertxFullHttpResponse(false, HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().newHeaders(), DefaultHttpHeadersFactory.trailersFactory().newHeaders(), false), promise);
    }

    void write103EarlyHints(io.netty.handler.codec.http.HttpHeaders headers, Promise<Void> promise) {
        this.write(new VertxFullHttpResponse(false, HttpVersion.HTTP_1_1, HttpResponseStatus.EARLY_HINTS, Unpooled.buffer((int)0), headers, (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE, false), promise);
    }

    @Override
    protected void handleClosed() {
        Http1xServerRequest responseInProgress = this.responseInProgress;
        if (responseInProgress != null) {
            responseInProgress.handleException(HttpUtils.CONNECTION_CLOSED_EXCEPTION);
        }
        super.handleClosed();
    }

    @Override
    public void handleException(Throwable t) {
        super.handleException(t);
        Http1xServerRequest responseInProgress = this.responseInProgress;
        Http1xServerRequest requestInProgress = this.requestInProgress;
        if (requestInProgress != null) {
            requestInProgress.reportMetricsFailed = true;
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.reportMetricsFailed = true;
            responseInProgress.handleException(t);
        }
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        ReferenceCountUtil.release((Object)obj);
        this.fail(result.cause());
    }
}

