/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.ContextBuilderImpl;
import io.vertx.core.impl.ContextLocalImpl;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.ContextBuilder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.core.spi.context.storage.ContextLocal;
import java.util.function.Supplier;

abstract class ContextBase
implements ContextInternal {
    final Object[] locals;

    ContextBase(Object[] locals) {
        this.locals = locals;
    }

    @Override
    public ContextInternal beginDispatch() {
        VertxImpl vertx = this.owner();
        return vertx.beginDispatch(this);
    }

    @Override
    public void endDispatch(ContextInternal previous) {
        VertxImpl vertx = this.owner();
        vertx.endDispatch(previous);
    }

    @Override
    public final <T> T getLocal(ContextLocal<T> key, AccessMode accessMode) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.locals.length) {
            throw new IllegalArgumentException();
        }
        Object res = accessMode.get(this.locals, index);
        return (T)res;
    }

    @Override
    public final <T> T getLocal(ContextLocal<T> key, AccessMode accessMode, Supplier<? extends T> initialValueSupplier) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.locals.length) {
            throw new IllegalArgumentException("Invalid key index: " + index);
        }
        Object res = accessMode.getOrCreate(this.locals, index, initialValueSupplier);
        return (T)res;
    }

    @Override
    public final <T> void putLocal(ContextLocal<T> key, AccessMode accessMode, T value) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.locals.length) {
            throw new IllegalArgumentException();
        }
        accessMode.put(this.locals, index, value);
    }

    @Override
    public final boolean inThread() {
        return this.executor().inThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> void emit(T argument, Handler<T> task) {
        if (this.executor().inThread()) {
            ContextInternal prev = this.beginDispatch();
            try {
                task.handle(argument);
            }
            catch (Throwable t) {
                this.reportException(t);
            }
            finally {
                this.endDispatch(prev);
            }
        } else {
            this.executor().execute(() -> this.emit(argument, task));
        }
    }

    @Override
    public final void execute(Runnable task) {
        if (this.executor().inThread()) {
            task.run();
        } else {
            this.executor().execute(task);
        }
    }

    @Override
    public final <T> void execute(T argument, Handler<T> task) {
        if (this.executor().inThread()) {
            task.handle(argument);
        } else {
            this.executor().execute(() -> task.handle(argument));
        }
    }

    @Override
    public abstract VertxImpl owner();

    @Override
    public ContextBuilder toBuilder() {
        return new ContextBuilderImpl(this.owner()).withCloseFuture(this.closeFuture()).withEventLoop(this.nettyEventLoop()).withThreadingModel(this.threadingModel()).withDeploymentContext(this.deployment()).withWorkerPool(this.workerPool()).withClassLoader(this.classLoader());
    }
}

