/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.transport;

import io.vertx.core.impl.Utils;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.impl.transports.TransportInternal;
import io.vertx.core.impl.transports.TransportLoader;

public interface Transport {
    public static final Transport NIO = new TransportInternal("nio", true, null, NioTransport.INSTANCE);
    public static final Transport KQUEUE = TransportLoader.kqueue();
    public static final Transport EPOLL = TransportLoader.epoll();
    public static final Transport IO_URING = TransportLoader.io_uring();

    public String name();

    public static Transport nativeTransport() {
        Transport transport;
        if (Utils.isLinux()) {
            transport = EPOLL;
            if (transport != null) {
                if (!transport.available() && IO_URING != null && IO_URING.available()) {
                    transport = IO_URING;
                }
            } else {
                transport = IO_URING;
            }
        } else {
            transport = Utils.isOsx() ? KQUEUE : null;
        }
        return transport;
    }

    public boolean available();

    public Throwable unavailabilityCause();

    public io.vertx.core.spi.transport.Transport implementation();
}

