/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.http.impl.VertxAssembledHttpRequest;

class VertxFullHttpRequest
extends VertxAssembledHttpRequest
implements FullHttpRequest {
    public VertxFullHttpRequest(HttpRequest request) {
        super(request, (HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, true);
    }

    public VertxFullHttpRequest(HttpRequest request, ByteBuf buf) {
        super(request, (HttpContent)VertxFullHttpRequest.toLastContent(buf), true);
    }

    private static LastHttpContent toLastContent(ByteBuf buf) {
        if (buf.isReadable()) {
            return new DefaultLastHttpContent(buf, false);
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    @Override
    public VertxFullHttpRequest replace(ByteBuf content) {
        super.replace(content);
        return this;
    }

    @Override
    public VertxFullHttpRequest retainedDuplicate() {
        super.retainedDuplicate();
        return this;
    }

    @Override
    public VertxFullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public VertxFullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public VertxFullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public VertxFullHttpRequest duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertxFullHttpRequest copy() {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders trailingHeaders() {
        return ((LastHttpContent)this.content).trailingHeaders();
    }

    @Override
    public VertxFullHttpRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public VertxFullHttpRequest retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public VertxFullHttpRequest touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public VertxFullHttpRequest touch() {
        super.touch();
        return this;
    }
}

